package io.resys.thena.docdb.spi.sql;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SqlBuilder.SqlTupleList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSqlTupleList.builder()}.
 */
@Generated(from = "SqlBuilder.SqlTupleList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSqlTupleList implements SqlBuilder.SqlTupleList {
  private final String value;
  private final ImmutableList<Tuple> props;

  private ImmutableSqlTupleList(
      String value,
      ImmutableList<Tuple> props) {
    this.value = value;
    this.props = props;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @Override
  public ImmutableList<Tuple> getProps() {
    return props;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SqlBuilder.SqlTupleList#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSqlTupleList withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableSqlTupleList(newValue, this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SqlBuilder.SqlTupleList#getProps() props}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSqlTupleList withProps(Tuple... elements) {
    ImmutableList<Tuple> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSqlTupleList(this.value, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SqlBuilder.SqlTupleList#getProps() props}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of props elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSqlTupleList withProps(Iterable<? extends Tuple> elements) {
    if (this.props == elements) return this;
    ImmutableList<Tuple> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSqlTupleList(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSqlTupleList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSqlTupleList
        && equalTo((ImmutableSqlTupleList) another);
  }

  private boolean equalTo(ImmutableSqlTupleList another) {
    return value.equals(another.value)
        && props.equals(another.props);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code props}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + props.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SqlTupleList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SqlTupleList")
        .omitNullValues()
        .add("value", value)
        .add("props", props)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SqlBuilder.SqlTupleList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SqlTupleList instance
   */
  public static ImmutableSqlTupleList copyOf(SqlBuilder.SqlTupleList instance) {
    if (instance instanceof ImmutableSqlTupleList) {
      return (ImmutableSqlTupleList) instance;
    }
    return ImmutableSqlTupleList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSqlTupleList ImmutableSqlTupleList}.
   * <pre>
   * ImmutableSqlTupleList.builder()
   *    .value(String) // required {@link SqlBuilder.SqlTupleList#getValue() value}
   *    .addProps|addAllProps(io.vertx.mutiny.sqlclient.Tuple) // {@link SqlBuilder.SqlTupleList#getProps() props} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSqlTupleList builder
   */
  public static ImmutableSqlTupleList.Builder builder() {
    return new ImmutableSqlTupleList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSqlTupleList ImmutableSqlTupleList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SqlBuilder.SqlTupleList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;
    private ImmutableList.Builder<Tuple> props = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SqlTupleList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SqlBuilder.SqlTupleList instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      addAllProps(instance.getProps());
      return this;
    }

    /**
     * Initializes the value for the {@link SqlBuilder.SqlTupleList#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link SqlBuilder.SqlTupleList#getProps() props} list.
     * @param element A props element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProps(Tuple element) {
      this.props.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SqlBuilder.SqlTupleList#getProps() props} list.
     * @param elements An array of props elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProps(Tuple... elements) {
      this.props.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SqlBuilder.SqlTupleList#getProps() props} list.
     * @param elements An iterable of props elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder props(Iterable<? extends Tuple> elements) {
      this.props = ImmutableList.builder();
      return addAllProps(elements);
    }

    /**
     * Adds elements to {@link SqlBuilder.SqlTupleList#getProps() props} list.
     * @param elements An iterable of props elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllProps(Iterable<? extends Tuple> elements) {
      this.props.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSqlTupleList ImmutableSqlTupleList}.
     * @return An immutable instance of SqlTupleList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSqlTupleList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSqlTupleList(value, props.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build SqlTupleList, some of required attributes are not set " + attributes;
    }
  }
}
