/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.mongo;

import com.mongodb.client.model.Filters;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ImmutableDeleteResult;
import io.resys.thena.docdb.spi.mongo.MongoClientWrapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;

public class MongoTagQuery
implements ClientQuery.TagQuery {
    private final MongoClientWrapper wrapper;
    private String name;

    public MongoTagQuery(MongoClientWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public ClientQuery.TagQuery name(String name) {
        this.name = name;
        return this;
    }

    public Uni<ClientQuery.DeleteResult> delete() {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getTags(), Objects.Tag.class).deleteOne(Filters.eq((String)"_id", (Object)this.name)).onItem().transform(result -> ImmutableDeleteResult.builder().deletedCount(result.getDeletedCount()).build());
    }

    public Uni<Objects.Tag> get() {
        return this.find().collect().first();
    }

    public Multi<Objects.Tag> find() {
        ClientCollections ctx = this.wrapper.getNames();
        if (this.name == null || this.name.isBlank()) {
            return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getTags(), Objects.Tag.class).find();
        }
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getTags(), Objects.Tag.class).find(Filters.eq((String)"_id", (Object)this.name));
    }
}

