/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.mongo;

import com.mongodb.client.model.Filters;
import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientState;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import org.bson.conversions.Bson;

public class MongoRepoBuilder
implements ClientState.RepoBuilder {
    private final ReactiveMongoClient client;
    private final ClientCollections names;

    public MongoRepoBuilder(ReactiveMongoClient client, ClientCollections names) {
        this.client = client;
        this.names = names;
    }

    public Uni<Repo> getByName(String name) {
        ClientCollections ctx = this.names;
        return this.client.getDatabase(ctx.getDb()).getCollection(ctx.getRepos(), Repo.class).find(Filters.or((Bson[])new Bson[]{Filters.eq((String)"name", (Object)name)})).collect().first();
    }

    public Uni<Repo> getByNameOrId(String nameOrId) {
        ClientCollections ctx = this.names;
        return this.client.getDatabase(ctx.getDb()).getCollection(ctx.getRepos(), Repo.class).find(Filters.or((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)nameOrId), Filters.eq((String)"name", (Object)nameOrId)})).collect().first();
    }

    public Uni<Repo> insert(Repo newRepo) {
        ClientCollections ctx = this.names;
        return this.client.getDatabase(ctx.getDb()).getCollection(ctx.getRepos(), Repo.class).insertOne((Object)newRepo).onItem().transform(insertOne -> newRepo);
    }

    public Multi<Repo> find() {
        ClientCollections ctx = this.names;
        return this.client.getDatabase(ctx.getDb()).getCollection(ctx.getRepos(), Repo.class).find();
    }

    public Uni<Void> create() {
        ClientCollections ctx = this.names;
        return this.client.getDatabase(ctx.getDb()).createCollection(ctx.getRepos());
    }
}

