/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.mongo;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ImmutableInsertResult;
import io.resys.thena.docdb.spi.ImmutableUpsertResult;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import io.resys.thena.docdb.spi.commits.ImmutableCommitOutput;
import io.resys.thena.docdb.spi.mongo.MongoClientWrapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import org.bson.conversions.Bson;

public class MongoClientInsertBuilder
implements ClientInsertBuilder {
    private final MongoClientWrapper wrapper;

    public MongoClientInsertBuilder(MongoClientWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public Uni<ClientInsertBuilder.InsertResult> tag(Objects.Tag tag) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getTags(), Objects.Tag.class).insertOne((Object)tag).onItem().transform(inserted -> ImmutableInsertResult.builder().duplicate(false).build()).onFailure(e -> {
            MongoWriteException t = (MongoWriteException)e;
            return t.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
        }).recoverWithItem(e -> ImmutableInsertResult.builder().duplicate(true).build());
    }

    public Uni<ClientInsertBuilder.UpsertResult> blob(Objects.Blob blob) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getBlobs(), Objects.Blob.class).insertOne((Object)blob).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(true).target((Object)blob).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> {
            if (!(e instanceof MongoWriteException)) {
                return false;
            }
            MongoWriteException t = (MongoWriteException)e;
            return t.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
        }).recoverWithItem(e -> ImmutableUpsertResult.builder().id(blob.getId()).isModified(false).target((Object)blob).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Blob with id:" + " '" + blob.getId() + "'" + " is already saved.").build()).build());
    }

    public Uni<ClientInsertBuilder.UpsertResult> ref(Objects.Ref ref, Objects.Commit commit) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getRefs(), Objects.Ref.class).find(Filters.eq((String)"_id", (Object)ref.getName())).collect().first().onItem().transformToUni(item -> {
            if (item == null) {
                return this.createRef(ref, commit);
            }
            return this.updateRef(ref, commit);
        });
    }

    public Uni<ClientInsertBuilder.UpsertResult> updateRef(Objects.Ref ref, Objects.Commit commit) {
        Bson filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)ref.getName()), Filters.eq((String)"commit", (Object)((String)commit.getParent().get()))});
        Bson updates = Updates.set((String)"commit", (Object)ref.getCommit());
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getRefs(), Objects.Ref.class).updateOne(filters, updates).onItem().transform(updateResult -> {
            if (updateResult.getModifiedCount() == 1L) {
                return ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).status(ClientInsertBuilder.UpsertStatus.OK).target((Object)ref).message((Message)ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been updated.").build()).build();
            }
            return ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).status(ClientInsertBuilder.UpsertStatus.CONFLICT).target((Object)ref).message((Message)ImmutableMessage.builder().text("Ref with" + " id: '" + ref.getName() + "'," + " commit: '" + ref.getCommit() + "'" + " is behind of the head.").build()).build();
        });
    }

    private Uni<ClientInsertBuilder.UpsertResult> createRef(Objects.Ref ref, Objects.Commit commit) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getRefs(), Objects.Ref.class).insertOne((Object)ref).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(true).target((Object)ref).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " has been created.").build()).build()).onFailure(e -> {
            MongoWriteException t = (MongoWriteException)e;
            return t.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
        }).recoverWithItem(e -> ImmutableUpsertResult.builder().id(ref.getName()).isModified(false).target((Object)ref).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message((Message)ImmutableMessage.builder().text("Ref with id:" + " '" + ref.getName() + "'" + " is already created.").build()).build());
    }

    public Uni<ClientInsertBuilder.UpsertResult> tree(Objects.Tree tree) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getTrees(), Objects.Tree.class).insertOne((Object)tree).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(true).target((Object)tree).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> {
            MongoWriteException t = (MongoWriteException)e;
            return t.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
        }).recoverWithItem(e -> ImmutableUpsertResult.builder().id(tree.getId()).isModified(false).target((Object)tree).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Tree with id:" + " '" + tree.getId() + "'" + " is already saved.").build()).build());
    }

    public Uni<ClientInsertBuilder.UpsertResult> commit(Objects.Commit commit) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getCommits(), Objects.Commit.class).insertOne((Object)commit).onItem().transform(updateResult -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(true).target((Object)commit).status(ClientInsertBuilder.UpsertStatus.OK).message((Message)ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " has been saved.").build()).build()).onFailure(e -> {
            MongoWriteException t = (MongoWriteException)e;
            return t.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
        }).recoverWithItem(e -> ImmutableUpsertResult.builder().id(commit.getId()).isModified(false).target((Object)commit).status(ClientInsertBuilder.UpsertStatus.CONFLICT).message((Message)ImmutableMessage.builder().text("Commit with id:" + " '" + commit.getId() + "'" + " is already saved.").build()).build());
    }

    public Uni<CommitVisitor.CommitOutput> output(CommitVisitor.CommitOutput output) {
        return Multi.createFrom().items(output.getBlobs().stream()).onItem().transformToUni(blob -> this.blob((Objects.Blob)blob)).merge().collect().asList().onItem().transform(upserts -> {
            ImmutableCommitOutput.Builder result = ImmutableCommitOutput.builder().from(output).status(CommitVisitor.CommitOutputStatus.OK);
            upserts.forEach(blob -> result.addMessages(blob.getMessage()));
            return result.build();
        }).onItem().transformToUni(current -> this.tree(current.getTree()).onItem().transform(upsert -> ImmutableCommitOutput.builder().from(current).status(this.visitStatus((ClientInsertBuilder.UpsertResult)upsert)).addMessages(upsert.getMessage()).build())).onItem().transformToUni(current -> {
            if (current.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                return this.commit(current.getCommit()).onItem().transform(upsert -> ImmutableCommitOutput.builder().from(current).status(this.visitStatus((ClientInsertBuilder.UpsertResult)upsert)).addMessages(upsert.getMessage()).build());
            }
            return Uni.createFrom().item(current);
        }).onItem().transformToUni(current -> {
            if (current.getStatus() == CommitVisitor.CommitOutputStatus.OK) {
                return this.ref(output.getRef(), output.getCommit()).onItem().transform(upsert -> this.transformRef((ClientInsertBuilder.UpsertResult)upsert, (CommitVisitor.CommitOutput)current));
            }
            return Uni.createFrom().item(current);
        });
    }

    private CommitVisitor.CommitOutput transformRef(ClientInsertBuilder.UpsertResult upsert, CommitVisitor.CommitOutput current) {
        return ImmutableCommitOutput.builder().from(current).status(this.visitStatus(upsert)).addMessages(upsert.getMessage()).build();
    }

    private CommitVisitor.CommitOutputStatus visitStatus(ClientInsertBuilder.UpsertResult upsert) {
        if (upsert.getStatus() == ClientInsertBuilder.UpsertStatus.OK) {
            return CommitVisitor.CommitOutputStatus.OK;
        }
        if (upsert.getStatus() == ClientInsertBuilder.UpsertStatus.DUPLICATE) {
            return CommitVisitor.CommitOutputStatus.EMPTY;
        }
        if (upsert.getStatus() == ClientInsertBuilder.UpsertStatus.CONFLICT) {
            return CommitVisitor.CommitOutputStatus.CONFLICT;
        }
        return CommitVisitor.CommitOutputStatus.ERROR;
    }
}

