/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.mongo;

import com.mongodb.client.model.Filters;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.mongo.MongoClientWrapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.stream.Collectors;

public class MongoBlobQuery
implements ClientQuery.BlobQuery {
    private final MongoClientWrapper wrapper;

    public MongoBlobQuery(MongoClientWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public Uni<Objects.Blob> id(String blobId) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getBlobs(), Objects.Blob.class).find(Filters.eq((String)"_id", (Object)blobId)).collect().first();
    }

    public Uni<List<Objects.Blob>> id(List<String> blobId) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getBlobs(), Objects.Blob.class).find(Filters.in((String)"_id", blobId)).collect().asList();
    }

    public Multi<Objects.Blob> find() {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getBlobs(), Objects.Blob.class).find();
    }

    public Multi<Objects.Blob> find(Objects.Tree tree) {
        ClientCollections ctx = this.wrapper.getNames();
        return this.wrapper.getClient().getDatabase(ctx.getDb()).getCollection(ctx.getBlobs(), Objects.Blob.class).find(Filters.or((Iterable)tree.getValues().values().stream().map(e -> Filters.eq((Object)e.getBlob())).collect(Collectors.toList())));
    }
}

