/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableTreeValue;
import io.resys.thena.docdb.api.models.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class TreeEntryCodec
implements Codec<Objects.TreeValue> {
    public static final String NAME = "name";
    private static final String BLOB = "blob";

    public void encode(BsonWriter writer, Objects.TreeValue command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(NAME, command.getName());
        writer.writeString(BLOB, command.getBlob());
        writer.writeEndDocument();
    }

    public Objects.TreeValue decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableTreeValue result = ImmutableTreeValue.builder().name(reader.readString(NAME)).blob(reader.readString(BLOB)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<Objects.TreeValue> getEncoderClass() {
        return Objects.TreeValue.class;
    }
}

