/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.codec.TreeEntryCodec;
import java.util.HashMap;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class TreeCodec
implements Codec<Objects.Tree> {
    public static final String ID = "_id";
    public static final String VALUES = "values";
    private final TreeEntryCodec entryCode;

    public TreeCodec(TreeEntryCodec entryCode) {
        this.entryCode = entryCode;
    }

    public void encode(BsonWriter writer, Objects.Tree value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, value.getId());
        writer.writeStartArray(VALUES);
        for (Objects.TreeValue command : value.getValues().values()) {
            this.entryCode.encode(writer, command, encoderContext);
        }
        writer.writeEndArray();
        writer.writeEndDocument();
    }

    public Objects.Tree decode(BsonReader reader, DecoderContext decoderContext) {
        ImmutableTree.Builder changes = ImmutableTree.builder();
        reader.readStartDocument();
        changes.id(reader.readString(ID));
        reader.readName(VALUES);
        reader.readStartArray();
        HashMap<String, Objects.TreeValue> commands = new HashMap<String, Objects.TreeValue>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            Objects.TreeValue entry = this.entryCode.decode(reader, decoderContext);
            commands.put(entry.getName(), entry);
        }
        reader.readEndArray();
        reader.readEndDocument();
        return changes.values(commands).build();
    }

    public Class<Objects.Tree> getEncoderClass() {
        return Objects.Tree.class;
    }
}

