/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableTag;
import io.resys.thena.docdb.api.models.Objects;
import java.time.LocalDateTime;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class TagCodec
implements Codec<Objects.Tag> {
    public static final String ID = "_id";
    public static final String COMMIT = "commit";
    public static final String DATE_TIME = "dateTime";
    public static final String AUTHOR = "author";
    public static final String MESSAGE = "message";

    public void encode(BsonWriter writer, Objects.Tag command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, command.getName());
        writer.writeString(COMMIT, command.getCommit());
        writer.writeString(DATE_TIME, command.getDateTime().toString());
        writer.writeString(AUTHOR, command.getAuthor());
        writer.writeString(MESSAGE, command.getMessage());
        writer.writeEndDocument();
    }

    public Objects.Tag decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableTag result = ImmutableTag.builder().name(reader.readString(ID)).commit(reader.readString(COMMIT)).dateTime(LocalDateTime.parse(reader.readString(DATE_TIME))).author(reader.readString(AUTHOR)).message(reader.readString(MESSAGE)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<Objects.Tag> getEncoderClass() {
        return Objects.Tag.class;
    }
}

