/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableRepo;
import io.resys.thena.docdb.api.models.Repo;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class RepoCodec
implements Codec<Repo> {
    public static final String ID = "_id";
    public static final String NAME = "name";
    public static final String REV = "rev";
    public static final String PREFIX = "prefix";

    public void encode(BsonWriter writer, Repo command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, command.getId());
        writer.writeString(REV, command.getRev());
        writer.writeString(PREFIX, command.getPrefix());
        writer.writeString(NAME, command.getName());
        writer.writeEndDocument();
    }

    public Repo decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        String repoId = reader.readString(ID);
        ImmutableRepo.Builder result = ImmutableRepo.builder().id(repoId).rev(reader.readString(REV)).prefix(reader.readString(PREFIX)).name(reader.readString(NAME));
        reader.readEndDocument();
        return result.build();
    }

    public Class<Repo> getEncoderClass() {
        return Repo.class;
    }
}

