/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableRef;
import io.resys.thena.docdb.api.models.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class RefCodec
implements Codec<Objects.Ref> {
    public static final String NAME = "_id";
    public static final String COMMIT = "commit";

    public void encode(BsonWriter writer, Objects.Ref command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(NAME, command.getName());
        writer.writeString(COMMIT, command.getCommit());
        writer.writeEndDocument();
    }

    public Objects.Ref decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableRef result = ImmutableRef.builder().name(reader.readString(NAME)).commit(reader.readString(COMMIT)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<Objects.Ref> getEncoderClass() {
        return Objects.Ref.class;
    }
}

