/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableCommit;
import io.resys.thena.docdb.api.models.Objects;
import java.time.LocalDateTime;
import java.util.Optional;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class CommitCodec
implements Codec<Objects.Commit> {
    public static final String ID = "_id";
    private static final String DATE_TIME = "dateTime";
    private static final String AUTHOR = "author";
    private static final String MESSAGE = "message";
    private static final String TREE = "tree";
    private static final String PARENT = "parent";
    private static final String MERGE = "merge";

    public void encode(BsonWriter writer, Objects.Commit command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, command.getId());
        writer.writeString(DATE_TIME, command.getDateTime().toString());
        writer.writeString(AUTHOR, command.getAuthor());
        writer.writeString(MESSAGE, command.getMessage());
        writer.writeString(TREE, command.getTree());
        if (command.getParent().isPresent()) {
            writer.writeString(PARENT, (String)command.getParent().get());
        } else {
            writer.writeNull(PARENT);
        }
        if (command.getMerge().isPresent()) {
            writer.writeString(MERGE, (String)command.getMerge().get());
        } else {
            writer.writeNull(MERGE);
        }
        writer.writeEndDocument();
    }

    public Objects.Commit decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableCommit result = ImmutableCommit.builder().id(reader.readString(ID)).dateTime(LocalDateTime.parse(reader.readString(DATE_TIME))).author(reader.readString(AUTHOR)).message(reader.readString(MESSAGE)).tree(reader.readString(TREE)).parent(Optional.ofNullable(this.isNull(PARENT, reader) ? null : reader.readString())).merge(Optional.ofNullable(this.isNull(MERGE, reader) ? null : reader.readString())).build();
        reader.readEndDocument();
        return result;
    }

    private boolean isNull(String id, BsonReader reader) {
        reader.readName(id);
        if (reader.getCurrentBsonType() == BsonType.NULL) {
            reader.readNull();
            return true;
        }
        return false;
    }

    public Class<Objects.Commit> getEncoderClass() {
        return Objects.Commit.class;
    }
}

