/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.codec;

import io.resys.thena.docdb.api.models.ImmutableBlob;
import io.resys.thena.docdb.api.models.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class BlobCodec
implements Codec<Objects.Blob> {
    public static final String ID = "_id";
    public static final String VALUE = "value";

    public void encode(BsonWriter writer, Objects.Blob command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, command.getId());
        writer.writeString(VALUE, command.getValue());
        writer.writeEndDocument();
    }

    public Objects.Blob decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableBlob result = ImmutableBlob.builder().id(reader.readString(ID)).value(reader.readString(VALUE)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<Objects.Blob> getEncoderClass() {
        return Objects.Blob.class;
    }
}

