/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import io.quarkus.mongodb.reactive.ReactiveMongoClient;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.DocDBDefault;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.mongo.ImmutableMongoClientWrapper;
import io.resys.thena.docdb.spi.mongo.MongoClientInsertBuilder;
import io.resys.thena.docdb.spi.mongo.MongoClientQuery;
import io.resys.thena.docdb.spi.mongo.MongoRepoBuilder;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;

public class DocDBFactory {
    public static Builder create() {
        return new Builder();
    }

    public static ClientState state(final ClientCollections ctx, final ReactiveMongoClient client) {
        ErrorHandler handler = new ErrorHandler(){

            public boolean notFound(Throwable e) {
                return false;
            }

            public boolean duplicate(Throwable e) {
                return false;
            }

            public void deadEnd(String additionalMsg) {
            }

            public void deadEnd(String additionalMsg, Throwable e) {
            }
        };
        return new ClientState(handler){
            final /* synthetic */ 1 val$handler;
            {
                this.val$handler = var3_3;
            }

            public ClientCollections getCollections() {
                return ctx;
            }

            public ClientState.RepoBuilder repos() {
                return new MongoRepoBuilder(client, ctx);
            }

            public Uni<ClientInsertBuilder> insert(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.insert((Repo)repo));
            }

            public ClientInsertBuilder insert(Repo repo) {
                ImmutableMongoClientWrapper wrapper = ImmutableMongoClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new MongoClientInsertBuilder(wrapper);
            }

            public Uni<ClientQuery> query(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.query((Repo)repo));
            }

            public ClientQuery query(Repo repo) {
                ImmutableMongoClientWrapper wrapper = ImmutableMongoClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new MongoClientQuery(wrapper);
            }

            public ClientState.ClientRepoState withRepo(Repo repo) {
                final ImmutableMongoClientWrapper wrapper = ImmutableMongoClientWrapper.builder().repo(repo).client(client).names(ctx.toRepo(repo)).build();
                return new ClientState.ClientRepoState(){

                    public ClientQuery query() {
                        return new MongoClientQuery(wrapper);
                    }

                    public ClientInsertBuilder insert() {
                        return new MongoClientInsertBuilder(wrapper);
                    }
                };
            }

            public Uni<ClientState.ClientRepoState> withRepo(String repoNameOrId) {
                return this.repos().getByNameOrId(repoNameOrId).onItem().transform(repo -> this.withRepo((Repo)repo));
            }

            public ErrorHandler getErrorHandler() {
                return this.val$handler;
            }
        };
    }

    public static class Builder {
        private ReactiveMongoClient client;
        private String db = "docdb";

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder client(ReactiveMongoClient client) {
            this.client = client;
            return this;
        }

        public DocDB build() {
            RepoAssert.notNull((Object)this.client, () -> "client must be defined!");
            RepoAssert.notNull((Object)this.db, () -> "db must be defined!");
            ClientCollections ctx = ClientCollections.defaults((String)this.db);
            return new DocDBDefault(DocDBFactory.state(ctx, this.client));
        }
    }
}

