/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.codec.BlobCodec;
import io.resys.thena.docdb.spi.codec.CommitCodec;
import io.resys.thena.docdb.spi.codec.RefCodec;
import io.resys.thena.docdb.spi.codec.RepoCodec;
import io.resys.thena.docdb.spi.codec.TagCodec;
import io.resys.thena.docdb.spi.codec.TreeCodec;
import io.resys.thena.docdb.spi.codec.TreeEntryCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class DocDBCodecProvider
implements CodecProvider {
    private final CommitCodec commit = new CommitCodec();
    private final BlobCodec blob = new BlobCodec();
    private final TreeEntryCodec treeEntry = new TreeEntryCodec();
    private final TreeCodec tree = new TreeCodec(this.treeEntry);
    private final TagCodec tag = new TagCodec();
    private final RefCodec ref = new RefCodec();
    private final RepoCodec repo = new RepoCodec();

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (Repo.class.isAssignableFrom(clazz)) {
            return this.repo;
        }
        if (Objects.Commit.class.isAssignableFrom(clazz)) {
            return this.commit;
        }
        if (Objects.Blob.class.isAssignableFrom(clazz)) {
            return this.blob;
        }
        if (Objects.Tree.class.isAssignableFrom(clazz)) {
            return this.tree;
        }
        if (Objects.TreeValue.class.isAssignableFrom(clazz)) {
            return this.treeEntry;
        }
        if (Objects.Tag.class.isAssignableFrom(clazz)) {
            return this.tag;
        }
        if (Objects.Ref.class.isAssignableFrom(clazz)) {
            return this.ref;
        }
        return null;
    }
}

