/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.defaults;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.sql.ImmutableSql;
import io.resys.thena.docdb.sql.ImmutableSqlTuple;
import io.resys.thena.docdb.sql.ImmutableSqlTupleList;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.defaults.SqlStatement;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.stream.Collectors;

public class DefaultTreeItemSqlBuilder
implements SqlBuilder.TreeItemSqlBuilder {
    private final ClientCollections options;

    public DefaultTreeItemSqlBuilder(ClientCollections options) {
        this.options = options;
    }

    @Override
    public SqlBuilder.Sql create() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("CREATE TABLE ").append(this.options.getTreeItems()).append("(").append("  id SERIAL PRIMARY KEY,").append("  name VARCHAR(255) NOT NULL,").append("  blob VARCHAR(40) NOT NULL,").append("  tree VARCHAR(40) NOT NULL").append(");").build()).build();
    }

    @Override
    public SqlBuilder.Sql constraints() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("ALTER TABLE ").append(this.options.getTreeItems()).ln().append("  ADD CONSTRAINT ").append(this.options.getTreeItems()).append("_TREE_ITEM_BLOB_FK").ln().append("  FOREIGN KEY (blob)").ln().append("  REFERENCES ").append(this.options.getBlobs()).append(" (id);").ln().append("ALTER TABLE ").append(this.options.getTreeItems()).ln().append("  ADD CONSTRAINT ").append(this.options.getTreeItems()).append("_TREE_ITEM_PARENT_FK").ln().append("  FOREIGN KEY (tree)").ln().append("  REFERENCES ").append(this.options.getTrees()).append(" (id);").ln().append("ALTER TABLE ").append(this.options.getTreeItems()).ln().append("  ADD CONSTRAINT ").append(this.options.getTreeItems()).append("_TREE_NAME_BLOB_UNIQUE").ln().append("  UNIQUE (tree, name, blob);").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTreeItems()).build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple getByTreeId(String treeId) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * ").ln().append("  FROM ").append(this.options.getTreeItems()).ln().append("  WHERE tree = $1").ln().build()).props(Tuple.of((Object)treeId)).build();
    }

    @Override
    public SqlBuilder.SqlTuple insertOne(Objects.Tree tree, Objects.TreeValue item) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getTreeItems()).append(" (name, blob, tree) VALUES($1, $2, $3)").ln().append(" ON CONFLICT (name, blob, tree) DO NOTHING").build()).props(Tuple.of((Object)item.getName(), (Object)item.getBlob(), (Object)tree.getId())).build();
    }

    @Override
    public SqlBuilder.SqlTupleList insertAll(Objects.Tree item) {
        return ImmutableSqlTupleList.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getTreeItems()).append(" (name, blob, tree) VALUES($1, $2, $3)").ln().append(" ON CONFLICT (name, blob, tree) DO NOTHING").build()).props(item.getValues().values().stream().map(v -> Tuple.of((Object)v.getName(), (Object)v.getBlob(), (Object)item.getId())).collect(Collectors.toList())).build();
    }
}

