/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.defaults;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientCollections;
import io.resys.thena.docdb.sql.ImmutableSql;
import io.resys.thena.docdb.sql.ImmutableSqlTuple;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.defaults.SqlStatement;
import io.vertx.mutiny.sqlclient.Tuple;

public class DefaultRefSqlBuilder
implements SqlBuilder.RefSqlBuilder {
    private final ClientCollections options;

    public DefaultRefSqlBuilder(ClientCollections options) {
        this.options = options;
    }

    @Override
    public SqlBuilder.Sql create() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("CREATE TABLE ").append(this.options.getRefs()).ln().append("(").ln().append("  name VARCHAR(100) PRIMARY KEY,").ln().append("  commit VARCHAR(40) NOT NULL").ln().append(");").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql constraints() {
        return ImmutableSql.builder().value(new SqlStatement().ln().append("ALTER TABLE ").append(this.options.getRefs()).ln().append("  ADD CONSTRAINT ").append(this.options.getRefs()).append("_REF_COMMIT_FK").ln().append("  FOREIGN KEY (commit)").ln().append("  REFERENCES ").append(this.options.getCommits()).append(" (id);").ln().build()).build();
    }

    @Override
    public SqlBuilder.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRefs()).build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple getByName(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRefs()).append(" WHERE name = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)name)).build();
    }

    @Override
    public SqlBuilder.SqlTuple getByNameOrCommit(String refNameOrCommit) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRefs()).append(" WHERE name = $1 OR commit = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of((Object)refNameOrCommit)).build();
    }

    @Override
    public SqlBuilder.Sql getFirst() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getRefs()).append(" FETCH FIRST ROW ONLY").build()).build();
    }

    @Override
    public SqlBuilder.SqlTuple insertOne(Objects.Ref ref) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getRefs()).append(" (name, commit) VALUES($1, $2)").build()).props(Tuple.of((Object)ref.getName(), (Object)ref.getCommit())).build();
    }

    @Override
    public SqlBuilder.SqlTuple updateOne(Objects.Ref ref, Objects.Commit commit) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("UPDATE ").append(this.options.getRefs()).append(" SET commit = $1").append(" WHERE name = $2 AND commit = $3").build()).props(Tuple.of((Object)ref.getCommit(), (Object)ref.getName(), (Object)commit.getParent().get())).build();
    }
}

