/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.ImmutableTree;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;

public class TreeQuerySqlPool
implements ClientQuery.TreeQuery {
    private final Pool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Tree> id(String tree) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.treeItems().getByTreeId(tree);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.treeItem((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            ImmutableTree.Builder builder = ImmutableTree.builder().id(tree);
            for (Objects.TreeValue item : rowset) {
                builder.putValues(item.getName(), item);
            }
            return builder.build();
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find/load 'TREE': " + tree + "!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Tree> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.trees().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.tree((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onItem().transformToUni(tree -> this.id(tree.getId())).concatenate().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TREE'!", (Throwable)e));
    }

    public TreeQuerySqlPool(Pool client, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

