/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.ImmutableDeleteResult;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;

public class TagQuerySqlPool
implements ClientQuery.TagQuery {
    private final Pool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;
    private String name;

    @Override
    public ClientQuery.TagQuery name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Uni<ClientQuery.DeleteResult> delete() {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.tags().deleteByName(this.name);
        return this.client.preparedQuery(sql.getValue()).execute(sql.getProps()).onItem().transform(result -> ImmutableDeleteResult.builder().deletedCount(1L).build()).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't delete 'TAG' by name: '" + this.name + "'!", (Throwable)e));
    }

    @Override
    public Uni<Objects.Tag> get() {
        SqlBuilder.Sql sql = this.sqlBuilder.tags().getFirst();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.tag((Row)row)).execute().onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Tag)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TAG'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Tag> find() {
        if (this.name == null || this.name.isBlank()) {
            SqlBuilder.Sql sql = this.sqlBuilder.tags().findAll();
            return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.tag((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TAG'!", (Throwable)e));
        }
        SqlBuilder.SqlTuple sql = this.sqlBuilder.tags().getByName(this.name);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.tag((Row)row)).execute(sql.getProps()).onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'TAG' by name: '" + this.name + "'!", (Throwable)e));
    }

    public TagQuerySqlPool(Pool client, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

