/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.sql.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.sql.SqlBuilder;
import io.resys.thena.docdb.sql.SqlMapper;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowIterator;

public class CommitQuerySqlPool
implements ClientQuery.CommitQuery {
    private final Pool client;
    private final SqlMapper sqlMapper;
    private final SqlBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Commit> id(String commit) {
        SqlBuilder.SqlTuple sql = this.sqlBuilder.commits().getById(commit);
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.commit((Row)row)).execute(sql.getProps()).onItem().transform(rowset -> {
            RowIterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Commit)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'COMMIT' by 'id': '" + commit + "'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Commit> find() {
        SqlBuilder.Sql sql = this.sqlBuilder.commits().findAll();
        return this.client.preparedQuery(sql.getValue()).mapping(row -> this.sqlMapper.commit((Row)row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'COMMIT'!", (Throwable)e));
    }

    public CommitQuerySqlPool(Pool client, SqlMapper sqlMapper, SqlBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.sqlMapper = sqlMapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

