/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.tags;

import io.resys.thena.docdb.api.actions.TagActions;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Optional;

public class AnyTagQuery
implements TagActions.TagQuery {
    private final ClientState state;
    private String repoId;
    private String tagName;

    public AnyTagQuery(ClientState state) {
        this.state = state;
    }

    @Override
    public TagActions.TagQuery tagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    @Override
    public TagActions.TagQuery repo(String repoId) {
        this.repoId = repoId;
        return this;
    }

    @Override
    public Multi<Objects.Tag> find() {
        RepoAssert.notEmpty(this.repoId, () -> "repoId can't be empty!");
        return this.state.query(this.repoId).onItem().transformToMulti(f -> f.tags().name(this.tagName).find());
    }

    @Override
    public Uni<Optional<Objects.Tag>> get() {
        RepoAssert.notEmpty(this.repoId, () -> "repoId can't be empty!");
        RepoAssert.notEmpty(this.tagName, () -> "tagName can't be empty!");
        return this.state.query(this.repoId).onItem().transformToUni(f -> f.tags().name(this.tagName).get()).onItem().transform(tag -> Optional.ofNullable(tag));
    }

    @Override
    public Uni<Optional<Objects.Tag>> delete() {
        RepoAssert.notEmpty(this.repoId, () -> "repoId can't be empty!");
        RepoAssert.notEmpty(this.tagName, () -> "tagName can't be empty!");
        return this.state.query(this.repoId).onItem().transformToUni(query -> query.tags().name(this.tagName).get().onItem().transformToUni(tag -> {
            if (tag == null) {
                return Uni.createFrom().item(Optional.empty());
            }
            return query.tags().delete().onItem().transform(delete -> {
                if (delete.getDeletedCount() > 0L) {
                    return Optional.of(tag);
                }
                return Optional.empty();
            });
        }));
    }
}

