/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.repo;

import io.resys.thena.docdb.api.actions.ImmutableRepoResult;
import io.resys.thena.docdb.api.actions.RepoActions;
import io.resys.thena.docdb.api.exceptions.RepoException;
import io.resys.thena.docdb.api.models.ImmutableRepo;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.support.Identifiers;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;

public class RepoCreateBuilder
implements RepoActions.CreateBuilder {
    private final ClientState state;
    private String name;

    public RepoCreateBuilder(ClientState state) {
        this.state = state;
    }

    @Override
    public RepoActions.CreateBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Uni<RepoActions.RepoResult> build() {
        RepoAssert.notEmpty(this.name, () -> "repo name not defined!");
        RepoAssert.isName(this.name, () -> "repo name has invalid charecters!");
        return this.state.repos().getByName(this.name).onItem().transformToUni(existing -> {
            Uni result = existing != null ? Uni.createFrom().item((Object)ImmutableRepoResult.builder().status(RepoActions.RepoStatus.CONFLICT).addMessages(RepoException.builder().nameNotUnique(existing.getName(), existing.getId())).build()) : this.state.repos().find().collect().asList().onItem().transformToUni(allRepos -> {
                ImmutableRepo newRepo = ImmutableRepo.builder().id(Identifiers.uuid()).rev(Identifiers.uuid()).name(this.name).prefix("nested_" + (allRepos.size() + 10) + "_").build();
                return this.state.repos().insert(newRepo).onItem().transform(next -> ImmutableRepoResult.builder().repo((Repo)next).status(RepoActions.RepoStatus.OK).build());
            });
            return result;
        });
    }
}

