/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.objects;

import io.resys.thena.docdb.api.actions.ImmutableObjectsResult;
import io.resys.thena.docdb.api.actions.ImmutableRefObjects;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.exceptions.RepoException;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.stream.Collectors;

public class RefStateBuilderDefault
implements ObjectsActions.RefStateBuilder {
    private final ClientState state;
    private String repoName;
    private String ref;
    private boolean blobs;

    public RefStateBuilderDefault(ClientState state) {
        this.state = state;
    }

    @Override
    public ObjectsActions.RefStateBuilder repo(String repoName) {
        this.repoName = repoName;
        return this;
    }

    @Override
    public ObjectsActions.RefStateBuilder ref(String ref) {
        this.ref = ref;
        return this;
    }

    @Override
    public ObjectsActions.RefStateBuilder blobs(boolean load) {
        this.blobs = load;
        return this;
    }

    @Override
    public ObjectsActions.RefStateBuilder blobs() {
        this.blobs = true;
        return this;
    }

    @Override
    public Uni<ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>> build() {
        RepoAssert.notEmpty(this.repoName, () -> "repoName is not defined!");
        RepoAssert.notEmpty(this.ref, () -> "ref is not defined!");
        return this.state.repos().getByNameOrId(this.repoName).onItem().transformToUni(existing -> {
            if (existing == null) {
                return Uni.createFrom().item(ImmutableObjectsResult.builder().status(ObjectsActions.ObjectsStatus.ERROR).addMessages(RepoException.builder().notRepoWithName(this.repoName)).build());
            }
            return this.getRef((Repo)existing, this.ref, this.state.withRepo((Repo)existing));
        });
    }

    private Uni<ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>> getRef(Repo repo, String refName, ClientState.ClientRepoState ctx) {
        return ctx.query().refs().name(refName).onItem().transformToUni(ref -> {
            if (ref == null) {
                return ctx.query().refs().find().collect().asList().onItem().transform(allRefs -> ImmutableObjectsResult.builder().repo(repo).status(ObjectsActions.ObjectsStatus.OK).addMessages(RepoException.builder().noRepoRef(repo.getName(), refName, allRefs.stream().map(e -> e.getName()).collect(Collectors.toList()))).build());
            }
            return this.getState(repo, (Objects.Ref)ref, ctx);
        });
    }

    private Uni<ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>> getState(Repo repo, Objects.Ref ref, ClientState.ClientRepoState ctx) {
        return this.getCommit(ref, ctx).onItem().transformToUni(commit -> this.getTree((Objects.Commit)commit, ctx).onItem().transformToUni(tree -> {
            if (this.blobs) {
                return this.getBlobs((Objects.Tree)tree, ctx).onItem().transform(blobs -> ImmutableObjectsResult.builder().repo(repo).objects(ImmutableRefObjects.builder().repo(repo).ref(ref).tree((Objects.Tree)tree).blobs((Map<String, ? extends Objects.Blob>)blobs).commit((Objects.Commit)commit).build()).repo(repo).status(ObjectsActions.ObjectsStatus.OK).build());
            }
            return Uni.createFrom().item(ImmutableObjectsResult.builder().repo(repo).objects(ImmutableRefObjects.builder().repo(repo).ref(ref).tree((Objects.Tree)tree).commit((Objects.Commit)commit).build()).status(ObjectsActions.ObjectsStatus.OK).build());
        }));
    }

    private Uni<Objects.Tree> getTree(Objects.Commit commit, ClientState.ClientRepoState ctx) {
        return ctx.query().trees().id(commit.getTree());
    }

    private Uni<Objects.Commit> getCommit(Objects.Ref ref, ClientState.ClientRepoState ctx) {
        return ctx.query().commits().id(ref.getCommit());
    }

    private Uni<Map<String, Objects.Blob>> getBlobs(Objects.Tree tree, ClientState.ClientRepoState ctx) {
        return ctx.query().blobs().find(tree).collect().asList().onItem().transform(blobs -> blobs.stream().collect(Collectors.toMap(r -> r.getId(), r -> r)));
    }
}

