/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.diff;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.spi.diff.CommitHistory;
import io.resys.thena.docdb.spi.diff.DiffVisitor;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DiffVisitor.DiffCommitMatch", generator="Immutables")
@Immutable
public final class ImmutableDiffCommitMatch
implements DiffVisitor.DiffCommitMatch {
    private final CommitHistory src;
    private final CommitHistory target;

    private ImmutableDiffCommitMatch(CommitHistory src, CommitHistory target) {
        this.src = src;
        this.target = target;
    }

    @Override
    public CommitHistory getSrc() {
        return this.src;
    }

    @Override
    public CommitHistory getTarget() {
        return this.target;
    }

    public final ImmutableDiffCommitMatch withSrc(CommitHistory value) {
        if (this.src == value) {
            return this;
        }
        CommitHistory newValue = Objects.requireNonNull(value, "src");
        return new ImmutableDiffCommitMatch(newValue, this.target);
    }

    public final ImmutableDiffCommitMatch withTarget(CommitHistory value) {
        if (this.target == value) {
            return this;
        }
        CommitHistory newValue = Objects.requireNonNull(value, "target");
        return new ImmutableDiffCommitMatch(this.src, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffCommitMatch && this.equalTo((ImmutableDiffCommitMatch)another);
    }

    private boolean equalTo(ImmutableDiffCommitMatch another) {
        return this.src.equals(another.src) && this.target.equals(another.target);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.src.hashCode();
        h += (h << 5) + this.target.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffCommitMatch").omitNullValues().add("src", (Object)this.src).add("target", (Object)this.target).toString();
    }

    public static ImmutableDiffCommitMatch copyOf(DiffVisitor.DiffCommitMatch instance) {
        if (instance instanceof ImmutableDiffCommitMatch) {
            return (ImmutableDiffCommitMatch)instance;
        }
        return ImmutableDiffCommitMatch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DiffVisitor.DiffCommitMatch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SRC = 1L;
        private static final long INIT_BIT_TARGET = 2L;
        private long initBits = 3L;
        @Nullable
        private CommitHistory src;
        @Nullable
        private CommitHistory target;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DiffVisitor.DiffCommitMatch instance) {
            Objects.requireNonNull(instance, "instance");
            this.src(instance.getSrc());
            this.target(instance.getTarget());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder src(CommitHistory src) {
            this.src = Objects.requireNonNull(src, "src");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder target(CommitHistory target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDiffCommitMatch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffCommitMatch(this.src, this.target);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("src");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("target");
            }
            return "Cannot build DiffCommitMatch, some of required attributes are not set " + attributes;
        }
    }
}

