/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.diff;

import io.resys.thena.docdb.api.actions.DiffActions;
import io.resys.thena.docdb.api.actions.ImmutableDiffResult;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Diff;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.diff.DiffVisitor;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.Arrays;

public class HeadDiffBuilderDefault
implements DiffActions.HeadDiffBuilder {
    private final ClientState state;
    private final ObjectsActions objects;
    private String repoIdOrName;
    private String leftHeadOrCommitOrTag;
    private String rightHeadOrCommitOrTag;

    public HeadDiffBuilderDefault(ClientState state, ObjectsActions objects) {
        this.state = state;
        this.objects = objects;
    }

    @Override
    public DiffActions.HeadDiffBuilder repo(String repoIdOrName) {
        this.repoIdOrName = repoIdOrName;
        return this;
    }

    @Override
    public DiffActions.HeadDiffBuilder left(String headOrCommitOrTag) {
        this.leftHeadOrCommitOrTag = headOrCommitOrTag;
        return this;
    }

    @Override
    public DiffActions.HeadDiffBuilder right(String headOrCommitOrTag) {
        this.rightHeadOrCommitOrTag = headOrCommitOrTag;
        return this;
    }

    @Override
    public Uni<DiffActions.DiffResult<Diff>> build() {
        RepoAssert.notEmpty(this.repoIdOrName, () -> "repoIdOrName is not defined!");
        RepoAssert.notEmpty(this.leftHeadOrCommitOrTag, () -> "leftHeadOrCommitOrTag is not defined!");
        RepoAssert.notEmpty(this.rightHeadOrCommitOrTag, () -> "rightHeadOrCommitOrTag is not defined!");
        return Uni.combine().all().unis(this.objects.repoState().repo(this.repoIdOrName).build(), this.objects.commitState().anyId(this.leftHeadOrCommitOrTag).repo(this.repoIdOrName).build(), this.objects.commitState().anyId(this.rightHeadOrCommitOrTag).repo(this.repoIdOrName).build()).asTuple().onItem().transform(tuple -> {
            ObjectsActions.ObjectsResult objects = (ObjectsActions.ObjectsResult)tuple.getItem1();
            ObjectsActions.ObjectsResult left = (ObjectsActions.ObjectsResult)tuple.getItem2();
            ObjectsActions.ObjectsResult right = (ObjectsActions.ObjectsResult)tuple.getItem3();
            if (left.getStatus() != ObjectsActions.ObjectsStatus.OK || right.getStatus() != ObjectsActions.ObjectsStatus.OK) {
                return ImmutableDiffResult.builder().addAllMessages(left.getMessages()).addAllMessages(right.getMessages()).status(DiffActions.DiffStatus.ERROR).build();
            }
            return this.createDiff((Objects)objects.getObjects(), (ObjectsActions.CommitObjects)left.getObjects(), (ObjectsActions.CommitObjects)right.getObjects());
        });
    }

    private DiffActions.DiffResult<Diff> createDiff(Objects objects, ObjectsActions.CommitObjects left, ObjectsActions.CommitObjects right) {
        Diff diff = new DiffVisitor().visit(objects, left, Arrays.asList(right));
        return ImmutableDiffResult.builder().repo(left.getRepo()).objects(diff).status(DiffActions.DiffStatus.OK).build();
    }
}

