/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.diff;

import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Diff;
import io.resys.thena.docdb.api.models.ImmutableDiff;
import io.resys.thena.docdb.api.models.ImmutableDivergence;
import io.resys.thena.docdb.api.models.ImmutableDivergenceRef;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.spi.diff.CommitHistory;
import io.resys.thena.docdb.spi.diff.ImmutableDiffCommitMatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class DiffVisitor {
    public Diff visit(Objects repo, ObjectsActions.CommitObjects start, List<ObjectsActions.CommitObjects> targets) {
        List<DiffCommitMatch> result = this.visitHistories(repo, CommitHistory.builder().from(repo, start.getCommit().getId()), targets);
        List values = result.stream().map(m -> this.visitDivergence(repo, (DiffCommitMatch)m)).collect(Collectors.toList());
        return ImmutableDiff.builder().divergences(values).repo(start.getRepo()).build();
    }

    private Diff.Divergence visitDivergence(Objects repo, DiffCommitMatch match) {
        CommitHistory main = match.getSrc();
        CommitHistory head = match.getTarget();
        return ImmutableDivergence.builder().main(ImmutableDivergenceRef.builder().commit(main.getCommit()).commits(main.getIndex()).tags(repo.getRefs().values().stream().filter(t -> t.getCommit().equals(main.getCommit().getId())).map(t -> t.getName()).collect(Collectors.toList())).tags(repo.getTags().values().stream().filter(t -> t.getCommit().equals(main.getCommit().getId())).map(t -> t.getName()).collect(Collectors.toList())).build()).head(ImmutableDivergenceRef.builder().commit(head.getCommit()).commits(head.getIndex()).tags(repo.getRefs().values().stream().filter(t -> t.getCommit().equals(head.getCommit().getId())).map(t -> t.getName()).collect(Collectors.toList())).tags(repo.getTags().values().stream().filter(t -> t.getCommit().equals(head.getCommit().getId())).map(t -> t.getName()).collect(Collectors.toList())).build()).type(Diff.DivergenceType.CONFLICT).build();
    }

    private List<DiffCommitMatch> visitHistories(Objects repo, CommitHistory start, List<ObjectsActions.CommitObjects> end) {
        ArrayList<DiffCommitMatch> result = new ArrayList<DiffCommitMatch>();
        ArrayList toBeVisited = new ArrayList(end.stream().map(e -> CommitHistory.builder().from(repo, e.getCommit().getId(), start.getCommit().getDateTime())).collect(Collectors.toList()));
        CommitHistory next = start;
        do {
            Iterator iterator = toBeVisited.iterator();
            while (iterator.hasNext()) {
                CommitHistory target = ((CommitHistory)iterator.next()).getSelect();
                Optional<DiffCommitMatch> match = this.visitHistory(next, target);
                if (!match.isPresent()) continue;
                iterator.remove();
                result.add(match.get());
            }
        } while ((next = (CommitHistory)next.getBefore().orElse(null)) != null);
        return result;
    }

    public Optional<DiffCommitMatch> visitHistory(CommitHistory start, CommitHistory target) {
        CommitHistory next = target;
        do {
            if (start.getCommit().getId().equals(next.getCommit().getId())) {
                return Optional.of(ImmutableDiffCommitMatch.builder().src(start).target(next).build());
            }
            if (!next.getCommit().getDateTime().isBefore(start.getCommit().getDateTime())) continue;
            return Optional.empty();
        } while ((next = (CommitHistory)start.getBefore().orElse(null)) != null);
        return Optional.empty();
    }

    @Value.Immutable
    public static interface DiffCommitMatch {
        public CommitHistory getSrc();

        public CommitHistory getTarget();
    }
}

