/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.resys.thena.docdb.api.models.ImmutableBlob;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public final class Sha2 {
    private static final TreeEntryComparator comparator = new TreeEntryComparator();

    public static String blobId(String blob) {
        String id = Hashing.murmur3_128().hashString((CharSequence)blob, Charsets.UTF_8).toString();
        return id;
    }

    public static String treeId(Map<String, Objects.TreeValue> values) {
        ArrayList<Objects.TreeValue> source = new ArrayList<Objects.TreeValue>(values.values());
        Collections.sort(source, comparator);
        String id = Hashing.murmur3_128().hashString((CharSequence)((Object)source).toString(), Charsets.UTF_8).toString();
        return id;
    }

    public static Objects.Blob id(Objects.Blob blob) {
        String id = Hashing.murmur3_128().hashString((CharSequence)blob.getValue(), Charsets.UTF_8).toString();
        return ImmutableBlob.builder().from(blob).id(id).build();
    }

    public static String commitId(Objects.Commit commit) {
        String id = Hashing.murmur3_128().hashString((CharSequence)commit.toString(), Charsets.UTF_8).toString();
        return id;
    }

    static class TreeEntryComparator
    implements Comparator<Objects.TreeValue> {
        TreeEntryComparator() {
        }

        @Override
        public int compare(Objects.TreeValue o1, Objects.TreeValue o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

