/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitVisitor.CommitInput", generator="Immutables")
@Immutable
public final class ImmutableCommitInput
implements CommitVisitor.CommitInput {
    @Nullable
    private final ObjectsActions.RefObjects parent;
    private final Repo repo;
    private final String ref;
    private final String commitAuthor;
    private final String commitMessage;
    private final ImmutableMap<String, String> append;
    private final Collection<String> remove;

    private ImmutableCommitInput(@Nullable ObjectsActions.RefObjects parent, Repo repo, String ref, String commitAuthor, String commitMessage, ImmutableMap<String, String> append, Collection<String> remove) {
        this.parent = parent;
        this.repo = repo;
        this.ref = ref;
        this.commitAuthor = commitAuthor;
        this.commitMessage = commitMessage;
        this.append = append;
        this.remove = remove;
    }

    @Override
    public Optional<ObjectsActions.RefObjects> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public String getCommitAuthor() {
        return this.commitAuthor;
    }

    @Override
    public String getCommitMessage() {
        return this.commitMessage;
    }

    public ImmutableMap<String, String> getAppend() {
        return this.append;
    }

    @Override
    public Collection<String> getRemove() {
        return this.remove;
    }

    public final ImmutableCommitInput withParent(ObjectsActions.RefObjects value) {
        ObjectsActions.RefObjects newValue = Objects.requireNonNull(value, "parent");
        if (this.parent == newValue) {
            return this;
        }
        return new ImmutableCommitInput(newValue, this.repo, this.ref, this.commitAuthor, this.commitMessage, this.append, this.remove);
    }

    public final ImmutableCommitInput withParent(Optional<? extends ObjectsActions.RefObjects> optional) {
        ObjectsActions.RefObjects value = optional.orElse(null);
        if (this.parent == value) {
            return this;
        }
        return new ImmutableCommitInput(value, this.repo, this.ref, this.commitAuthor, this.commitMessage, this.append, this.remove);
    }

    public final ImmutableCommitInput withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableCommitInput(this.parent, newValue, this.ref, this.commitAuthor, this.commitMessage, this.append, this.remove);
    }

    public final ImmutableCommitInput withRef(String value) {
        String newValue = Objects.requireNonNull(value, "ref");
        if (this.ref.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitInput(this.parent, this.repo, newValue, this.commitAuthor, this.commitMessage, this.append, this.remove);
    }

    public final ImmutableCommitInput withCommitAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "commitAuthor");
        if (this.commitAuthor.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitInput(this.parent, this.repo, this.ref, newValue, this.commitMessage, this.append, this.remove);
    }

    public final ImmutableCommitInput withCommitMessage(String value) {
        String newValue = Objects.requireNonNull(value, "commitMessage");
        if (this.commitMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, newValue, this.append, this.remove);
    }

    public final ImmutableCommitInput withAppend(Map<String, ? extends String> entries) {
        if (this.append == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, this.commitMessage, (ImmutableMap<String, String>)newValue, this.remove);
    }

    public final ImmutableCommitInput withRemove(Collection<String> value) {
        if (this.remove == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "remove");
        return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, this.commitMessage, this.append, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitInput && this.equalTo((ImmutableCommitInput)another);
    }

    private boolean equalTo(ImmutableCommitInput another) {
        return Objects.equals(this.parent, another.parent) && this.repo.equals(another.repo) && this.ref.equals(another.ref) && this.commitAuthor.equals(another.commitAuthor) && this.commitMessage.equals(another.commitMessage) && this.append.equals(another.append) && this.remove.equals(another.remove);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + this.commitAuthor.hashCode();
        h += (h << 5) + this.commitMessage.hashCode();
        h += (h << 5) + this.append.hashCode();
        h += (h << 5) + this.remove.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitInput").omitNullValues().add("parent", (Object)this.parent).add("repo", (Object)this.repo).add("ref", (Object)this.ref).add("commitAuthor", (Object)this.commitAuthor).add("commitMessage", (Object)this.commitMessage).add("append", this.append).add("remove", this.remove).toString();
    }

    public static ImmutableCommitInput copyOf(CommitVisitor.CommitInput instance) {
        if (instance instanceof ImmutableCommitInput) {
            return (ImmutableCommitInput)instance;
        }
        return ImmutableCommitInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitVisitor.CommitInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_REF = 2L;
        private static final long INIT_BIT_COMMIT_AUTHOR = 4L;
        private static final long INIT_BIT_COMMIT_MESSAGE = 8L;
        private static final long INIT_BIT_REMOVE = 16L;
        private long initBits = 31L;
        @Nullable
        private ObjectsActions.RefObjects parent;
        @Nullable
        private Repo repo;
        @Nullable
        private String ref;
        @Nullable
        private String commitAuthor;
        @Nullable
        private String commitMessage;
        private ImmutableMap.Builder<String, String> append = ImmutableMap.builder();
        @Nullable
        private Collection<String> remove;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitVisitor.CommitInput instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<ObjectsActions.RefObjects> parentOptional = instance.getParent();
            if (parentOptional.isPresent()) {
                this.parent(parentOptional);
            }
            this.repo(instance.getRepo());
            this.ref(instance.getRef());
            this.commitAuthor(instance.getCommitAuthor());
            this.commitMessage(instance.getCommitMessage());
            this.putAllAppend(instance.getAppend());
            this.remove(instance.getRemove());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(ObjectsActions.RefObjects parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(Optional<? extends ObjectsActions.RefObjects> parent) {
            this.parent = parent.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(String ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitAuthor(String commitAuthor) {
            this.commitAuthor = Objects.requireNonNull(commitAuthor, "commitAuthor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = Objects.requireNonNull(commitMessage, "commitMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAppend(String key, String value) {
            this.append.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAppend(Map.Entry<String, ? extends String> entry) {
            this.append.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder append(Map<String, ? extends String> entries) {
            this.append = ImmutableMap.builder();
            return this.putAllAppend(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAppend(Map<String, ? extends String> entries) {
            this.append.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remove(Collection<String> remove) {
            this.remove = Objects.requireNonNull(remove, "remove");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableCommitInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitInput(this.parent, this.repo, this.ref, this.commitAuthor, this.commitMessage, (ImmutableMap<String, String>)this.append.build(), this.remove);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ref");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commitAuthor");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("commitMessage");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("remove");
            }
            return "Cannot build CommitInput, some of required attributes are not set " + attributes;
        }
    }
}

