/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi.commits;

import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.actions.ImmutableCommitResult;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.spi.ClientState;
import io.resys.thena.docdb.spi.commits.CommitSaveVisitor;
import io.resys.thena.docdb.spi.commits.CommitVisitor;
import io.resys.thena.docdb.spi.commits.ImmutableCommitInput;
import io.resys.thena.docdb.spi.support.Identifiers;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HeadCommitBuilderDefault
implements CommitActions.HeadCommitBuilder {
    private final ClientState state;
    private final ObjectsActions objectsActions;
    private final Map<String, String> appendBlobs = new HashMap<String, String>();
    private final List<String> deleteBlobs = new ArrayList<String>();
    private String headGid;
    private String repoId;
    private String headName;
    private String author;
    private String message;
    private String parentCommit;
    private Boolean parentIsLatest;

    public HeadCommitBuilderDefault(ClientState state, ObjectsActions objectsActions) {
        this.state = state;
        this.objectsActions = objectsActions;
    }

    @Override
    public CommitActions.HeadCommitBuilder id(String headGid) {
        RepoAssert.isEmpty(this.headName, () -> "Can't defined id when head is defined!");
        this.headGid = headGid;
        return this;
    }

    @Override
    public CommitActions.HeadCommitBuilder head(String repoId, String headName) {
        RepoAssert.isEmpty(this.headGid, () -> "Can't defined head when id is defined!");
        RepoAssert.notEmpty(repoId, () -> "repoId can't be empty!");
        RepoAssert.notEmpty(headName, () -> "headName can't be empty!");
        RepoAssert.isName(headName, () -> "headName has invalid charecters!");
        this.repoId = repoId;
        this.headName = headName;
        return this;
    }

    @Override
    public CommitActions.HeadCommitBuilder append(String name, String blob) {
        RepoAssert.notEmpty(blob, () -> "blob can't be empty!");
        RepoAssert.notEmpty(name, () -> "name can't be empty!");
        RepoAssert.isTrue(!this.appendBlobs.containsKey(name), () -> "Blob with name: '" + name + "' is already defined!");
        RepoAssert.isTrue(!this.deleteBlobs.contains(name), () -> "Blob with name: '" + name + "' can't be appended because it's been marked for removal!");
        this.appendBlobs.put(name, blob);
        return this;
    }

    @Override
    public CommitActions.HeadCommitBuilder remove(String name) {
        RepoAssert.isTrue(!this.appendBlobs.containsKey(name), () -> "Blob with name: '" + name + "' can't be marked for removal because it's beed appended!");
        RepoAssert.isTrue(!this.deleteBlobs.contains(name), () -> "Blob with name: '" + name + "' is already marked for removal!");
        RepoAssert.notEmpty(name, () -> "name can't be empty!");
        this.deleteBlobs.add(name);
        return this;
    }

    @Override
    public CommitActions.HeadCommitBuilder author(String author) {
        RepoAssert.notEmpty(author, () -> "author can't be empty!");
        this.author = author;
        return this;
    }

    @Override
    public CommitActions.HeadCommitBuilder message(String message) {
        RepoAssert.notEmpty(message, () -> "message can't be empty!");
        this.message = message;
        return this;
    }

    @Override
    public CommitActions.HeadCommitBuilder parent(String parentCommit) {
        this.parentCommit = parentCommit;
        return this;
    }

    @Override
    public Uni<CommitActions.CommitResult> build() {
        RepoAssert.notEmpty(this.author, () -> "author can't be empty!");
        RepoAssert.notEmpty(this.message, () -> "message can't be empty!");
        RepoAssert.isTrue(!this.appendBlobs.isEmpty() || !this.deleteBlobs.isEmpty(), () -> "Nothing to commit, no content!");
        if (this.headGid != null) {
            String[] id = Identifiers.fromRepoHeadGid(this.headGid);
            this.repoId = id[0];
            this.headName = id[1];
        }
        RepoAssert.notEmpty(this.repoId, () -> "Can't resolve repoId!");
        RepoAssert.notEmpty(this.headName, () -> "Can't resolve headName!");
        String gid = Identifiers.toRepoHeadGid(this.repoId, this.headName);
        return this.objectsActions.refState().repo(this.repoId).ref(this.headName).build().onItem().transformToUni(state -> {
            CommitActions.CommitResult result = this.validateState((ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state, gid);
            if (result != null) {
                return Uni.createFrom().item((Object)result);
            }
            return this.createCommit((ObjectsActions.ObjectsResult<ObjectsActions.RefObjects>)state, gid);
        });
    }

    private CommitActions.CommitResult validateState(ObjectsActions.ObjectsResult<ObjectsActions.RefObjects> state, String gid) {
        if (state.getStatus() == ObjectsActions.ObjectsStatus.ERROR) {
            return ImmutableCommitResult.builder().gid(gid).addAllMessages(state.getMessages()).status(CommitActions.CommitStatus.ERROR).build();
        }
        if (state.getObjects() == null && this.parentCommit != null) {
            return ImmutableCommitResult.builder().gid(gid).addMessages((Message)ImmutableMessage.builder().text("Commit to head: '" + this.headName + "'" + " is rejected." + " Your head is: '" + this.parentCommit + "')" + " but remote has no head." + "'!").build()).status(CommitActions.CommitStatus.ERROR).build();
        }
        if (state.getObjects() != null && this.parentCommit == null && !Boolean.TRUE.equals(this.parentIsLatest)) {
            return ImmutableCommitResult.builder().gid(gid).addMessages((Message)ImmutableMessage.builder().text("Parent commit can only be undefined for the first commit!" + " Parent commit for" + " head: '" + this.headName + "'" + " is: '" + state.getObjects().getRef().getCommit() + "'!").build()).status(CommitActions.CommitStatus.ERROR).build();
        }
        if (state.getObjects() != null && this.parentCommit != null && !this.parentCommit.equals(state.getObjects().getRef().getCommit()) && !Boolean.TRUE.equals(this.parentIsLatest)) {
            String text = "Commit to head: '" + this.headName + "'" + " is rejected." + " Your head is: '" + this.parentCommit + "')" + " but remote is: '" + state.getObjects().getRef().getCommit() + "'!";
            return ImmutableCommitResult.builder().gid(gid).addMessages((Message)ImmutableMessage.builder().text(text).build()).status(CommitActions.CommitStatus.ERROR).build();
        }
        return null;
    }

    private Uni<CommitActions.CommitResult> createCommit(ObjectsActions.ObjectsResult<ObjectsActions.RefObjects> state, String gid) {
        CommitVisitor.CommitOutput toBeSaved = new CommitVisitor().visit(ImmutableCommitInput.builder().commitAuthor(this.author).commitMessage(this.message).ref(this.headName).append(this.appendBlobs).remove(this.deleteBlobs).repo(state.getRepo()).parent(Optional.ofNullable(state.getObjects())).build());
        return new CommitSaveVisitor(this.state.withRepo(state.getRepo())).visit(toBeSaved).onItem().transform(saved -> ImmutableCommitResult.builder().gid(gid).commit(saved.getCommit()).addAllMessages(saved.getMessages()).addMessages(saved.getLog()).status(this.visitStatus(saved.getStatus())).build());
    }

    private CommitActions.CommitStatus visitStatus(CommitVisitor.CommitOutputStatus src) {
        if (src == CommitVisitor.CommitOutputStatus.OK) {
            return CommitActions.CommitStatus.OK;
        }
        if (src == CommitVisitor.CommitOutputStatus.CONFLICT) {
            return CommitActions.CommitStatus.CONFLICT;
        }
        return CommitActions.CommitStatus.ERROR;
    }

    @Override
    public CommitActions.HeadCommitBuilder parentIsLatest() {
        this.parentIsLatest = true;
        return this;
    }
}

