/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.spi.ClientInsertBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientInsertBuilder.UpsertResult", generator="Immutables")
@Immutable
public final class ImmutableUpsertResult
implements ClientInsertBuilder.UpsertResult {
    private final String id;
    private final boolean isModified;
    private final Message message;
    private final Object target;
    private final ClientInsertBuilder.UpsertStatus status;

    private ImmutableUpsertResult(String id, boolean isModified, Message message, Object target, ClientInsertBuilder.UpsertStatus status) {
        this.id = id;
        this.isModified = isModified;
        this.message = message;
        this.target = target;
        this.status = status;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public ClientInsertBuilder.UpsertStatus getStatus() {
        return this.status;
    }

    public final ImmutableUpsertResult withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableUpsertResult(newValue, this.isModified, this.message, this.target, this.status);
    }

    public final ImmutableUpsertResult withIsModified(boolean value) {
        if (this.isModified == value) {
            return this;
        }
        return new ImmutableUpsertResult(this.id, value, this.message, this.target, this.status);
    }

    public final ImmutableUpsertResult withMessage(Message value) {
        if (this.message == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "message");
        return new ImmutableUpsertResult(this.id, this.isModified, newValue, this.target, this.status);
    }

    public final ImmutableUpsertResult withTarget(Object value) {
        if (this.target == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "target");
        return new ImmutableUpsertResult(this.id, this.isModified, this.message, newValue, this.status);
    }

    public final ImmutableUpsertResult withStatus(ClientInsertBuilder.UpsertStatus value) {
        if (this.status == value) {
            return this;
        }
        ClientInsertBuilder.UpsertStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableUpsertResult(this.id, this.isModified, this.message, this.target, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpsertResult && this.equalTo((ImmutableUpsertResult)another);
    }

    private boolean equalTo(ImmutableUpsertResult another) {
        return this.id.equals(another.id) && this.isModified == another.isModified && this.message.equals(another.message) && this.target.equals(another.target) && this.status.equals((Object)another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isModified);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + this.status.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UpsertResult").omitNullValues().add("id", (Object)this.id).add("isModified", this.isModified).add("message", (Object)this.message).add("target", this.target).add("status", (Object)this.status).toString();
    }

    public static ImmutableUpsertResult copyOf(ClientInsertBuilder.UpsertResult instance) {
        if (instance instanceof ImmutableUpsertResult) {
            return (ImmutableUpsertResult)instance;
        }
        return ImmutableUpsertResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientInsertBuilder.UpsertResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IS_MODIFIED = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long INIT_BIT_TARGET = 8L;
        private static final long INIT_BIT_STATUS = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        private boolean isModified;
        @Nullable
        private Message message;
        @Nullable
        private Object target;
        @Nullable
        private ClientInsertBuilder.UpsertStatus status;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientInsertBuilder.UpsertResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.isModified(instance.isModified());
            this.message(instance.getMessage());
            this.target(instance.getTarget());
            this.status(instance.getStatus());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isModified(boolean isModified) {
            this.isModified = isModified;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(Message message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder target(Object target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(ClientInsertBuilder.UpsertStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableUpsertResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpsertResult(this.id, this.isModified, this.message, this.target, this.status);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isModified");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("target");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build UpsertResult, some of required attributes are not set " + attributes;
        }
    }
}

