/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;
import java.util.HashMap;
import java.util.function.Function;

public class DocDBTestPrinter {
    private final ClientState state;

    public DocDBTestPrinter(ClientState state) {
        this.state = state;
    }

    public String print(Repo repo) {
        HashMap replacements = new HashMap();
        Function<String, String> ID = id -> {
            if (replacements.containsKey(id)) {
                return (String)replacements.get(id);
            }
            String next = String.valueOf(replacements.size() + 1);
            replacements.put(id, next);
            return next;
        };
        ClientState.ClientRepoState ctx = this.state.withRepo(repo);
        StringBuilder result = new StringBuilder();
        result.append(System.lineSeparator()).append("Repo").append(System.lineSeparator()).append("  - id: ").append(ID.apply(repo.getId())).append(", rev: ").append(ID.apply(repo.getRev())).append(System.lineSeparator()).append("    name: ").append(repo.getName()).append(", prefix: ").append(repo.getPrefix()).append(System.lineSeparator());
        result.append(System.lineSeparator()).append("Refs").append(System.lineSeparator());
        ctx.query().refs().find().onItem().transform(item -> {
            result.append("  - ").append((String)ID.apply(item.getCommit())).append(": ").append(item.getName()).append(System.lineSeparator());
            return item;
        }).collectItems().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Tags").append(System.lineSeparator());
        ctx.query().tags().find().onItem().transform(item -> {
            result.append("  - id: ").append(item.getName()).append(System.lineSeparator()).append("    commit: ").append((String)ID.apply(item.getCommit())).append(", message: ").append(item.getMessage()).append(System.lineSeparator());
            return item;
        }).collectItems().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Commits").append(System.lineSeparator());
        ctx.query().commits().find().onItem().transform(item -> {
            result.append("  - id: ").append((String)ID.apply(item.getId())).append(System.lineSeparator()).append("    tree: ").append((String)ID.apply(item.getTree())).append(", parent: ").append(item.getParent().map(e -> (String)ID.apply((String)e)).orElse("")).append(", message: ").append(item.getMessage()).append(System.lineSeparator());
            return item;
        }).collectItems().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Trees").append(System.lineSeparator());
        ctx.query().trees().find().onItem().transform(item -> {
            result.append("  - id: ").append((String)ID.apply(item.getId())).append(System.lineSeparator());
            item.getValues().entrySet().forEach(e -> result.append("    ").append(((Objects.TreeValue)e.getValue()).getBlob()).append(": ").append(((Objects.TreeValue)e.getValue()).getName()).append(System.lineSeparator()));
            return item;
        }).collectItems().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Blobs").append(System.lineSeparator());
        ctx.query().blobs().find().onItem().transform(item -> {
            result.append("  - ").append(item.getId()).append(": ").append(item.getValue()).append(System.lineSeparator());
            return item;
        }).collectItems().asList().await().indefinitely();
        return result.toString();
    }
}

