/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import io.resys.thena.docdb.api.models.Diff;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientState;

public class DocDBPrettyPrinter {
    private final ClientState state;

    public DocDBPrettyPrinter(ClientState state) {
        this.state = state;
    }

    public String print(Diff diff) {
        Repo repo = diff.getRepo();
        StringBuilder result = new StringBuilder();
        result.append(System.lineSeparator()).append("Diff").append(System.lineSeparator()).append("  - id: ").append(repo.getId()).append(", rev: ").append(repo.getRev()).append(System.lineSeparator()).append(System.lineSeparator());
        result.append("Divergences").append(System.lineSeparator());
        for (Diff.Divergence divergence : diff.getDivergences()) {
            result.append("  - head: ").append(divergence.getHead().getCommit().getId()).append(" alias: ").append(String.join((CharSequence)", ", divergence.getHead().getRefs())).append(System.lineSeparator()).append("    main: ").append(divergence.getMain().getCommit().getId()).append(" alias: ").append(String.join((CharSequence)", ", divergence.getMain().getRefs())).append(System.lineSeparator()).append("    commits in main: ").append(divergence.getMain().getCommits()).append(System.lineSeparator()).append("    commits in head: ").append(divergence.getHead().getCommits()).append(System.lineSeparator());
        }
        return result.toString();
    }

    public String print(Repo repo) {
        ClientState.ClientRepoState ctx = this.state.withRepo(repo);
        StringBuilder result = new StringBuilder();
        result.append(System.lineSeparator()).append("Repo").append(System.lineSeparator()).append("  - id: ").append(repo.getId()).append(", rev: ").append(repo.getRev()).append(System.lineSeparator()).append("    name: ").append(repo.getName()).append(", prefix: ").append(repo.getPrefix()).append(System.lineSeparator());
        result.append(System.lineSeparator()).append("Refs").append(System.lineSeparator());
        ctx.query().refs().find().onItem().transform(item -> {
            result.append("  - ").append(item.getCommit()).append(": ").append(item.getName()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Tags").append(System.lineSeparator());
        ctx.query().tags().find().onItem().transform(item -> {
            result.append("  - id: ").append(item.getName()).append(System.lineSeparator()).append("    commit: ").append(item.getCommit()).append(", dateTime: ").append(item.getDateTime()).append(", message: ").append(item.getMessage()).append(", author: ").append(item.getAuthor()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Commits").append(System.lineSeparator());
        ctx.query().commits().find().onItem().transform(item -> {
            result.append("  - id: ").append(item.getId()).append(System.lineSeparator()).append("    tree: ").append(item.getTree()).append(", dateTime: ").append(item.getDateTime()).append(", parent: ").append(item.getParent().orElse("")).append(", message: ").append(item.getMessage()).append(", author: ").append(item.getAuthor()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Trees").append(System.lineSeparator());
        ctx.query().trees().find().onItem().transform(item -> {
            result.append("  - id: ").append(item.getId()).append(System.lineSeparator());
            item.getValues().entrySet().forEach(e -> result.append("    ").append(((Objects.TreeValue)e.getValue()).getBlob()).append(": ").append(((Objects.TreeValue)e.getValue()).getName()).append(System.lineSeparator()));
            return item;
        }).collect().asList().await().indefinitely();
        result.append(System.lineSeparator()).append("Blobs").append(System.lineSeparator());
        ctx.query().blobs().find().onItem().transform(item -> {
            result.append("  - ").append(item.getId()).append(": ").append(item.getValue()).append(System.lineSeparator());
            return item;
        }).collect().asList().await().indefinitely();
        return result.toString();
    }
}

