/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.spi;

import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ImmutableClientCollections;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ClientCollections {
    public abstract String getDb();

    public abstract String getRepos();

    public abstract String getRefs();

    public abstract String getTags();

    public abstract String getBlobs();

    public abstract String getTrees();

    public abstract String getTreeItems();

    public abstract String getCommits();

    public ClientCollections toRepo(Repo repo) {
        String prefix = repo.getPrefix();
        return ImmutableClientCollections.builder().db(this.getDb()).repos(this.getRepos()).refs(prefix + this.getRefs()).tags(prefix + this.getTags()).blobs(prefix + this.getBlobs()).trees(prefix + this.getTrees()).treeItems(prefix + this.getTreeItems()).commits(prefix + this.getCommits()).build();
    }

    public static ClientCollections defaults(String db) {
        return ImmutableClientCollections.builder().db(db == null ? "docdb" : db).repos("repos").refs("refs").tags("tags").blobs("blobs").trees("trees").treeItems("treeItems").commits("commits").build();
    }
}

