/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.RefTable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefTable.RefTableRow", generator="Immutables")
@Immutable
public final class ImmutableRefTableRow
implements RefTable.RefTableRow {
    private final String name;
    private final String commit;

    private ImmutableRefTableRow(String name, String commit) {
        this.name = name;
        this.commit = commit;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="commit")
    public String getCommit() {
        return this.commit;
    }

    public final ImmutableRefTableRow withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRefTableRow(newValue, this.commit);
    }

    public final ImmutableRefTableRow withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableRefTableRow(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefTableRow && this.equalTo((ImmutableRefTableRow)another);
    }

    private boolean equalTo(ImmutableRefTableRow another) {
        return this.name.equals(another.name) && this.commit.equals(another.commit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.commit.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefTableRow").omitNullValues().add("name", (Object)this.name).add("commit", (Object)this.commit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRefTableRow fromJson(Json json) {
        Builder builder = ImmutableRefTableRow.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.commit != null) {
            builder.commit(json.commit);
        }
        return builder.build();
    }

    public static ImmutableRefTableRow copyOf(RefTable.RefTableRow instance) {
        if (instance instanceof ImmutableRefTableRow) {
            return (ImmutableRefTableRow)instance;
        }
        return ImmutableRefTableRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RefTable.RefTableRow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String commit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RefTable.RefTableRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.commit(instance.getCommit());
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="commit")
        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRefTableRow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefTableRow(this.name, this.commit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            return "Cannot build RefTableRow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RefTable.RefTableRow", generator="Immutables")
    static final class Json
    implements RefTable.RefTableRow {
        @Nullable
        String name;
        @Nullable
        String commit;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="commit")
        public void setCommit(String commit) {
            this.commit = commit;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommit() {
            throw new UnsupportedOperationException();
        }
    }
}

