/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.Table;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Table.FileTuple", generator="Immutables")
@Immutable
public final class ImmutableFileTuple
implements Table.FileTuple {
    private final String value;
    private final Function<Table.Connection, List<? extends Table.Row>> command;
    private final Tuple props;

    private ImmutableFileTuple(String value, Function<Table.Connection, List<? extends Table.Row>> command, Tuple props) {
        this.value = value;
        this.command = command;
        this.props = props;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Function<Table.Connection, List<? extends Table.Row>> getCommand() {
        return this.command;
    }

    @Override
    public Tuple getProps() {
        return this.props;
    }

    public final ImmutableFileTuple withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableFileTuple(newValue, this.command, this.props);
    }

    public final ImmutableFileTuple withCommand(Function<Table.Connection, List<? extends Table.Row>> value) {
        if (this.command == value) {
            return this;
        }
        Function<Table.Connection, List<? extends Table.Row>> newValue = Objects.requireNonNull(value, "command");
        return new ImmutableFileTuple(this.value, newValue, this.props);
    }

    public final ImmutableFileTuple withProps(Tuple value) {
        if (this.props == value) {
            return this;
        }
        Tuple newValue = Objects.requireNonNull(value, "props");
        return new ImmutableFileTuple(this.value, this.command, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileTuple && this.equalTo((ImmutableFileTuple)another);
    }

    private boolean equalTo(ImmutableFileTuple another) {
        return this.value.equals(another.value) && this.command.equals(another.command) && this.props.equals((Object)another.props);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.props.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileTuple").omitNullValues().add("value", (Object)this.value).add("command", this.command).add("props", (Object)this.props).toString();
    }

    public static ImmutableFileTuple copyOf(Table.FileTuple instance) {
        if (instance instanceof ImmutableFileTuple) {
            return (ImmutableFileTuple)instance;
        }
        return ImmutableFileTuple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Table.FileTuple", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private static final long INIT_BIT_PROPS = 4L;
        private long initBits = 7L;
        @Nullable
        private String value;
        @Nullable
        private Function<Table.Connection, List<? extends Table.Row>> command;
        @Nullable
        private Tuple props;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileTuple instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Table.FileCommand instance;
            if (object instanceof Table.FileCommand) {
                instance = (Table.FileCommand)object;
                this.value(instance.getValue());
                this.command(instance.getCommand());
            }
            if (object instanceof Table.FileTuple) {
                instance = (Table.FileTuple)object;
                this.props(instance.getProps());
            }
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder command(Function<Table.Connection, List<? extends Table.Row>> command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder props(Tuple props) {
            this.props = Objects.requireNonNull(props, "props");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFileTuple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileTuple(this.value, this.command, this.props);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("props");
            }
            return "Cannot build FileTuple, some of required attributes are not set " + attributes;
        }
    }
}

