/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Table.FileStatement", generator="Immutables")
@Immutable
public final class ImmutableFileStatement
implements Table.FileStatement {
    private final String value;
    private final Function<Table.Connection, List<? extends Table.Row>> command;

    private ImmutableFileStatement(String value, Function<Table.Connection, List<? extends Table.Row>> command) {
        this.value = value;
        this.command = command;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Function<Table.Connection, List<? extends Table.Row>> getCommand() {
        return this.command;
    }

    public final ImmutableFileStatement withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableFileStatement(newValue, this.command);
    }

    public final ImmutableFileStatement withCommand(Function<Table.Connection, List<? extends Table.Row>> value) {
        if (this.command == value) {
            return this;
        }
        Function<Table.Connection, List<? extends Table.Row>> newValue = Objects.requireNonNull(value, "command");
        return new ImmutableFileStatement(this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileStatement && this.equalTo((ImmutableFileStatement)another);
    }

    private boolean equalTo(ImmutableFileStatement another) {
        return this.value.equals(another.value) && this.command.equals(another.command);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.command.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileStatement").omitNullValues().add("value", (Object)this.value).add("command", this.command).toString();
    }

    public static ImmutableFileStatement copyOf(Table.FileStatement instance) {
        if (instance instanceof ImmutableFileStatement) {
            return (ImmutableFileStatement)instance;
        }
        return ImmutableFileStatement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Table.FileStatement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private long initBits = 3L;
        @Nullable
        private String value;
        @Nullable
        private Function<Table.Connection, List<? extends Table.Row>> command;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Table.FileStatement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Table.FileCommand) {
                Table.FileCommand instance = (Table.FileCommand)object;
                this.value(instance.getValue());
                this.command(instance.getCommand());
            }
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder command(Function<Table.Connection, List<? extends Table.Row>> command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFileStatement build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileStatement(this.value, this.command);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build FileStatement, some of required attributes are not set " + attributes;
        }
    }
}

