/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.CommitTable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitTable.CommitTableRow", generator="Immutables")
@Immutable
public final class ImmutableCommitTableRow
implements CommitTable.CommitTableRow {
    private final String id;
    private final String datetime;
    private final String author;
    private final String message;
    private final String tree;
    @Nullable
    private final String parent;
    @Nullable
    private final String merge;

    private ImmutableCommitTableRow(String id, String datetime, String author, String message, String tree, @Nullable String parent, @Nullable String merge) {
        this.id = id;
        this.datetime = datetime;
        this.author = author;
        this.message = message;
        this.tree = tree;
        this.parent = parent;
        this.merge = merge;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="datetime")
    public String getDatetime() {
        return this.datetime;
    }

    @Override
    @JsonProperty(value="author")
    public String getAuthor() {
        return this.author;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="tree")
    public String getTree() {
        return this.tree;
    }

    @Override
    @JsonProperty(value="parent")
    @Nullable
    public String getParent() {
        return this.parent;
    }

    @Override
    @JsonProperty(value="merge")
    @Nullable
    public String getMerge() {
        return this.merge;
    }

    public final ImmutableCommitTableRow withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitTableRow(newValue, this.datetime, this.author, this.message, this.tree, this.parent, this.merge);
    }

    public final ImmutableCommitTableRow withDatetime(String value) {
        String newValue = Objects.requireNonNull(value, "datetime");
        if (this.datetime.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitTableRow(this.id, newValue, this.author, this.message, this.tree, this.parent, this.merge);
    }

    public final ImmutableCommitTableRow withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitTableRow(this.id, this.datetime, newValue, this.message, this.tree, this.parent, this.merge);
    }

    public final ImmutableCommitTableRow withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitTableRow(this.id, this.datetime, this.author, newValue, this.tree, this.parent, this.merge);
    }

    public final ImmutableCommitTableRow withTree(String value) {
        String newValue = Objects.requireNonNull(value, "tree");
        if (this.tree.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitTableRow(this.id, this.datetime, this.author, this.message, newValue, this.parent, this.merge);
    }

    public final ImmutableCommitTableRow withParent(@Nullable String value) {
        if (Objects.equals(this.parent, value)) {
            return this;
        }
        return new ImmutableCommitTableRow(this.id, this.datetime, this.author, this.message, this.tree, value, this.merge);
    }

    public final ImmutableCommitTableRow withMerge(@Nullable String value) {
        if (Objects.equals(this.merge, value)) {
            return this;
        }
        return new ImmutableCommitTableRow(this.id, this.datetime, this.author, this.message, this.tree, this.parent, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitTableRow && this.equalTo((ImmutableCommitTableRow)another);
    }

    private boolean equalTo(ImmutableCommitTableRow another) {
        return this.id.equals(another.id) && this.datetime.equals(another.datetime) && this.author.equals(another.author) && this.message.equals(another.message) && this.tree.equals(another.tree) && Objects.equals(this.parent, another.parent) && Objects.equals(this.merge, another.merge);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.datetime.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.tree.hashCode();
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + Objects.hashCode(this.merge);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitTableRow").omitNullValues().add("id", (Object)this.id).add("datetime", (Object)this.datetime).add("author", (Object)this.author).add("message", (Object)this.message).add("tree", (Object)this.tree).add("parent", (Object)this.parent).add("merge", (Object)this.merge).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitTableRow fromJson(Json json) {
        Builder builder = ImmutableCommitTableRow.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.datetime != null) {
            builder.datetime(json.datetime);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.tree != null) {
            builder.tree(json.tree);
        }
        if (json.parent != null) {
            builder.parent(json.parent);
        }
        if (json.merge != null) {
            builder.merge(json.merge);
        }
        return builder.build();
    }

    public static ImmutableCommitTableRow copyOf(CommitTable.CommitTableRow instance) {
        if (instance instanceof ImmutableCommitTableRow) {
            return (ImmutableCommitTableRow)instance;
        }
        return ImmutableCommitTableRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitTable.CommitTableRow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DATETIME = 2L;
        private static final long INIT_BIT_AUTHOR = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private static final long INIT_BIT_TREE = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String datetime;
        @Nullable
        private String author;
        @Nullable
        private String message;
        @Nullable
        private String tree;
        @Nullable
        private String parent;
        @Nullable
        private String merge;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitTable.CommitTableRow instance) {
            String mergeValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.datetime(instance.getDatetime());
            this.author(instance.getAuthor());
            this.message(instance.getMessage());
            this.tree(instance.getTree());
            String parentValue = instance.getParent();
            if (parentValue != null) {
                this.parent(parentValue);
            }
            if ((mergeValue = instance.getMerge()) != null) {
                this.merge(mergeValue);
            }
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="datetime")
        @CanIgnoreReturnValue
        public final Builder datetime(String datetime) {
            this.datetime = Objects.requireNonNull(datetime, "datetime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="author")
        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="message")
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="tree")
        @CanIgnoreReturnValue
        public final Builder tree(String tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="parent")
        @CanIgnoreReturnValue
        public final Builder parent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        @JsonProperty(value="merge")
        @CanIgnoreReturnValue
        public final Builder merge(@Nullable String merge) {
            this.merge = merge;
            return this;
        }

        public ImmutableCommitTableRow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitTableRow(this.id, this.datetime, this.author, this.message, this.tree, this.parent, this.merge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("datetime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("tree");
            }
            return "Cannot build CommitTableRow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitTable.CommitTableRow", generator="Immutables")
    static final class Json
    implements CommitTable.CommitTableRow {
        @Nullable
        String id;
        @Nullable
        String datetime;
        @Nullable
        String author;
        @Nullable
        String message;
        @Nullable
        String tree;
        @Nullable
        String parent;
        @Nullable
        String merge;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="datetime")
        public void setDatetime(String datetime) {
            this.datetime = datetime;
        }

        @JsonProperty(value="author")
        public void setAuthor(String author) {
            this.author = author;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="tree")
        public void setTree(String tree) {
            this.tree = tree;
        }

        @JsonProperty(value="parent")
        public void setParent(@Nullable String parent) {
            this.parent = parent;
        }

        @JsonProperty(value="merge")
        public void setMerge(@Nullable String merge) {
            this.merge = merge;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDatetime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTree() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMerge() {
            throw new UnsupportedOperationException();
        }
    }
}

