/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.file.tables.BlobTable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BlobTable.BlobTableRow", generator="Immutables")
@Immutable
public final class ImmutableBlobTableRow
implements BlobTable.BlobTableRow {
    private final String id;
    private final String value;

    private ImmutableBlobTableRow(String id, String value) {
        this.id = id;
        this.value = value;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public final ImmutableBlobTableRow withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableBlobTableRow(newValue, this.value);
    }

    public final ImmutableBlobTableRow withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableBlobTableRow(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlobTableRow && this.equalTo((ImmutableBlobTableRow)another);
    }

    private boolean equalTo(ImmutableBlobTableRow another) {
        return this.id.equals(another.id) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BlobTableRow").omitNullValues().add("id", (Object)this.id).add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBlobTableRow fromJson(Json json) {
        Builder builder = ImmutableBlobTableRow.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableBlobTableRow copyOf(BlobTable.BlobTableRow instance) {
        if (instance instanceof ImmutableBlobTableRow) {
            return (ImmutableBlobTableRow)instance;
        }
        return ImmutableBlobTableRow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BlobTable.BlobTableRow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BlobTable.BlobTableRow instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.value(instance.getValue());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBlobTableRow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlobTableRow(this.id, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build BlobTableRow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BlobTable.BlobTableRow", generator="Immutables")
    static final class Json
    implements BlobTable.BlobTableRow {
        @Nullable
        String id;
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

