/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.ImmutableTagTableRow;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.file.tables.TagTable;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TagFileBuilderImpl
implements FileBuilder.TagFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create TAG table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).getTags().create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement constraints() {
        return ImmutableFileStatement.builder().value("Apply constraints on table TAG").command(conn -> Arrays.asList(new Table.Row(){})).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("Select all from TAG table").command(root -> root.getRepoTable(this.ctx).getTags().getRows()).build();
    }

    @Override
    public Table.FileTuple getByName(String name) {
        return ImmutableFileTuple.builder().value("Select by name from TAG table").command(root -> root.getRepoTable(this.ctx).getTags().getRows().stream().filter(r -> r.getId().equals(name)).collect(Collectors.toList())).props(Tuple.of((Object)name)).build();
    }

    @Override
    public Table.FileStatement getFirst() {
        return ImmutableFileStatement.builder().value("Select first from TAG table").command(root -> {
            List refs = root.getRepoTable(this.ctx).getTags().getRows();
            if (refs.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList((TagTable.TagTableRow)refs.get(0));
        }).build();
    }

    @Override
    public Table.FileTuple deleteByName(String name) {
        return ImmutableFileTuple.builder().value("Delete row from TAG table").command(root -> {
            Optional<TagTable.TagTableRow> exists = root.getRepoTable(this.ctx).getTags().getRows().stream().filter(r -> r.getId().equals(name)).findFirst();
            if (exists.isEmpty()) {
                throw new IllegalArgumentException("Can't find TAG with name: " + name);
            }
            root.getRepoTable(this.ctx).getTags().delete(exists.get());
            return Arrays.asList(exists.get());
        }).props(Tuple.of((Object)name)).build();
    }

    @Override
    public Table.FileTuple insertOne(Objects.Tag newTag) {
        return ImmutableFileTuple.builder().value("Insert new row into TAG table").command(root -> {
            Optional<TagTable.TagTableRow> exists = root.getRepoTable(this.ctx).getTags().getRows().stream().filter(r -> r.getId().equals(newTag.getName())).findFirst();
            if (!exists.isEmpty()) {
                return Arrays.asList(exists.get());
            }
            ImmutableTagTableRow newRow = ImmutableTagTableRow.builder().id(newTag.getName()).commit(newTag.getCommit()).datetime(newTag.getDateTime().toString()).author(newTag.getAuthor()).message(newTag.getMessage()).build();
            root.getRepoTable(this.ctx).getTags().insert(newRow);
            return Arrays.asList(newRow);
        }).props(Tuple.of((Object)newTag.getName(), (Object)newTag.getCommit(), (Object)newTag.getDateTime().toString(), (Object)newTag.getAuthor(), (Object)newTag.getMessage())).build();
    }

    public TagFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

