/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.resys.thena.docdb.file.spi.FileConnection;
import io.resys.thena.docdb.file.spi.FileTuplePreparedQuery;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.support.RepoAssert;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePoolImpl
implements Table.FilePool {
    private static final Logger log = LoggerFactory.getLogger(FilePoolImpl.class);
    private final File rootDir;
    private final ObjectMapper objectMapper;
    private final FileConnection conn;

    public FilePoolImpl(File rootDir, ObjectMapper objectMapper) {
        this.rootDir = rootDir;
        RepoAssert.isTrue(rootDir.exists(), () -> "root directory: '" + rootDir.getAbsolutePath() + "' must exist!");
        RepoAssert.isTrue(rootDir.canWrite(), () -> "root directory: '" + rootDir.getAbsolutePath() + "' must be writtable!");
        RepoAssert.isTrue(rootDir.canRead(), () -> "root directory: '" + rootDir.getAbsolutePath() + "' must be readable!");
        this.objectMapper = objectMapper;
        this.conn = new FileConnection(rootDir, objectMapper);
    }

    @Override
    public Table.FilePreparedQuery<Object> preparedQuery(Table.FileStatement query) {
        return new FileTuplePreparedQuery<Object>(this.rootDir, query, null, this.objectMapper, this.conn);
    }

    @Override
    public Table.FilePreparedQuery<Object> preparedQuery(Table.FileTuple query) {
        return new FileTuplePreparedQuery<Object>(this.rootDir, query, null, this.objectMapper, this.conn);
    }

    @Override
    public Table.FilePreparedQuery<Object> preparedQuery(Table.FileTupleList query) {
        return new FileTuplePreparedQuery<Object>(this.rootDir, query, null, this.objectMapper, this.conn);
    }
}

