/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.CommitTable;
import io.resys.thena.docdb.file.tables.ImmutableCommitTableRow;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class CommitFileBuilderImpl
implements FileBuilder.CommitFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create COMMIT table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).getCommits().create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement constraints() {
        return ImmutableFileStatement.builder().value("Apply constraints on table COMMIT").command(conn -> Arrays.asList(new Table.Row(){})).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("Select all from COMMIT table").command(root -> root.getRepoTable(this.ctx).getCommits().getRows()).build();
    }

    @Override
    public Table.FileTuple getById(String id) {
        return ImmutableFileTuple.builder().value("Select by id from COMMIT table").command(root -> root.getRepoTable(this.ctx).getCommits().getRows().stream().filter(r -> r.getId().equals(id)).collect(Collectors.toList())).props(Tuple.of((Object)id)).build();
    }

    @Override
    public Table.FileTuple insertOne(Objects.Commit commit) {
        String message = commit.getMessage();
        if (commit.getMessage().length() > 100) {
            message = message.substring(0, 100);
        }
        return ImmutableFileTuple.builder().value("Insert new row into COMMIT table").command(root -> {
            Optional<CommitTable.CommitTableRow> exists = root.getRepoTable(this.ctx).getCommits().getRows().stream().filter(r -> r.getId().equals(commit.getId())).findFirst();
            if (!exists.isEmpty()) {
                return Arrays.asList(exists.get());
            }
            ImmutableCommitTableRow newRow = ImmutableCommitTableRow.builder().id(commit.getId()).datetime(commit.getDateTime().toString()).author(commit.getAuthor()).message(commit.getMessage()).tree(commit.getTree()).parent(commit.getParent().orElse(null)).merge(commit.getMerge().orElse(null)).build();
            root.getRepoTable(this.ctx).getCommits().insert(newRow);
            return Arrays.asList(newRow);
        }).props(Tuple.from(Arrays.asList(commit.getId(), commit.getDateTime().toString(), commit.getAuthor(), message, commit.getTree(), commit.getParent().orElse(null), commit.getMerge().orElse(null)))).build();
    }

    public CommitFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

