/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.spi;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.BlobTable;
import io.resys.thena.docdb.file.tables.ImmutableBlobTableRow;
import io.resys.thena.docdb.file.tables.ImmutableFileStatement;
import io.resys.thena.docdb.file.tables.ImmutableFileTuple;
import io.resys.thena.docdb.file.tables.ImmutableFileTupleList;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientCollections;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BlobFileBuilderImpl
implements FileBuilder.BlobFileBuilder {
    private final ClientCollections ctx;

    @Override
    public Table.FileStatement create() {
        return ImmutableFileStatement.builder().value("create BLOB table if it does not exist").command(root -> {
            root.getRepoTable(this.ctx).getBlobs().create();
            return Arrays.asList(new Table.Row(){});
        }).build();
    }

    @Override
    public Table.FileStatement findAll() {
        return ImmutableFileStatement.builder().value("Select all from BLOB table").command(root -> root.getRepoTable(this.ctx).getBlobs().getRows()).build();
    }

    @Override
    public Table.FileTuple getById(String blobId) {
        return ImmutableFileTuple.builder().value("Select by id from BLOB table").command(root -> root.getRepoTable(this.ctx).getBlobs().getRows().stream().filter(r -> r.getId().equals(blobId)).collect(Collectors.toList())).props(Tuple.of((Object)blobId)).build();
    }

    @Override
    public Table.FileTuple findByIds(Collection<String> blobId) {
        ArrayList<String> tuple = new ArrayList<String>();
        for (String id : blobId) {
            tuple.add(id);
        }
        return ImmutableFileTuple.builder().value("Select by multiple id-s from BLOB table").command(root -> root.getRepoTable(this.ctx).getBlobs().getRows().stream().filter(r -> blobId.contains(r.getId())).collect(Collectors.toList())).props(Tuple.from(tuple)).build();
    }

    @Override
    public Table.FileTuple findByTree(Objects.Tree tree) {
        return ImmutableFileTuple.builder().value("Select by tree from BLOB and TREE_ITEM table").command(root -> {
            List ids = root.getRepoTable(this.ctx).getTreeItems().getRows().stream().filter(item -> item.getTree().equals(tree.getId())).map(item -> item.getBlob()).collect(Collectors.toList());
            return root.getRepoTable(this.ctx).getBlobs().getRows().stream().filter(r -> ids.contains(r.getId())).collect(Collectors.toList());
        }).props(Tuple.of((Object)tree.getId())).build();
    }

    @Override
    public Table.FileTuple insertOne(Objects.Blob blob) {
        return ImmutableFileTuple.builder().value("Insert new row into BLOB table").command(root -> {
            Optional<BlobTable.BlobTableRow> exists = root.getRepoTable(this.ctx).getBlobs().getRows().stream().filter(r -> r.getId().equals(blob.getId())).findFirst();
            if (!exists.isEmpty()) {
                return Arrays.asList(exists.get());
            }
            ImmutableBlobTableRow newRow = ImmutableBlobTableRow.builder().id(blob.getId()).value(blob.getValue()).build();
            root.getRepoTable(this.ctx).getBlobs().insert(newRow);
            return Arrays.asList(newRow);
        }).props(Tuple.of((Object)blob.getId(), (Object)blob.getValue())).build();
    }

    @Override
    public Table.FileTupleList insertAll(Collection<Objects.Blob> blobs) {
        return ImmutableFileTupleList.builder().value("Insert new rows into BLOB table").command(root -> {
            Map<String, BlobTable.BlobTableRow> byId = root.getRepoTable(this.ctx).getBlobs().getRows().stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
            ArrayList<ImmutableBlobTableRow> inserts = new ArrayList<ImmutableBlobTableRow>();
            ArrayList<BlobTable.BlobTableRow> results = new ArrayList<BlobTable.BlobTableRow>();
            for (Objects.Blob blob : blobs) {
                if (byId.containsKey(blob.getId())) {
                    results.add(byId.get(blob.getId()));
                    continue;
                }
                ImmutableBlobTableRow newRow = ImmutableBlobTableRow.builder().id(blob.getId()).value(blob.getValue()).build();
                inserts.add(newRow);
                results.add(newRow);
            }
            root.getRepoTable(this.ctx).getBlobs().insertAll(inserts);
            return results;
        }).props(blobs.stream().map(v -> Tuple.of((Object)v.getId(), (Object)v.getValue())).collect(Collectors.toList())).build();
    }

    public BlobFileBuilderImpl(ClientCollections ctx) {
        this.ctx = ctx;
    }
}

