/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.resys.thena.docdb.spi.support.RepoAssert;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Iterator;

public class RefQueryFilePool
implements ClientQuery.RefQuery {
    private final Table.FilePool client;
    private final Table.FileMapper mapper;
    private final FileBuilder sqlBuilder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Ref> nameOrCommit(String refNameOrCommit) {
        RepoAssert.notEmpty(refNameOrCommit, () -> "refNameOrCommit must be defined!");
        Table.FileTuple sql = this.sqlBuilder.refs().getByNameOrCommit(refNameOrCommit);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.ref(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF' by refNameOrCommit: '" + refNameOrCommit + "'!", (Throwable)e));
    }

    @Override
    public Uni<Objects.Ref> get() {
        Table.FileStatement sql = this.sqlBuilder.refs().getFirst();
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.ref(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Ref> find() {
        Table.FileStatement sql = this.sqlBuilder.refs().findAll();
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.ref(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF'!", (Throwable)e));
    }

    @Override
    public Uni<Objects.Ref> name(String name) {
        RepoAssert.notEmpty(name, () -> "name must be defined!");
        Table.FileTuple sql = this.sqlBuilder.refs().getByName(name);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.ref(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Ref)it.next();
            }
            return null;
        }).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'REF' by name: '" + name + "'!", (Throwable)e));
    }

    public RefQueryFilePool(Table.FilePool client, Table.FileMapper mapper, FileBuilder sqlBuilder, ErrorHandler errorHandler) {
        this.client = client;
        this.mapper = mapper;
        this.sqlBuilder = sqlBuilder;
        this.errorHandler = errorHandler;
    }
}

