/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.file.builders;

import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.file.FileBuilder;
import io.resys.thena.docdb.file.tables.Table;
import io.resys.thena.docdb.spi.ClientQuery;
import io.resys.thena.docdb.spi.ErrorHandler;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Iterator;

public class CommitQueryFilePool
implements ClientQuery.CommitQuery {
    private final Table.FilePool client;
    private final Table.FileMapper mapper;
    private final FileBuilder builder;
    private final ErrorHandler errorHandler;

    @Override
    public Uni<Objects.Commit> id(String commit) {
        Table.FileTuple sql = this.builder.commits().getById(commit);
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.commit(row)).execute().onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (it.hasNext()) {
                return (Objects.Commit)it.next();
            }
            return null;
        }).onFailure(e -> this.errorHandler.notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'COMMIT' by 'id': '" + commit + "'!", (Throwable)e));
    }

    @Override
    public Multi<Objects.Commit> find() {
        Table.FileStatement sql = this.builder.commits().findAll();
        return this.client.preparedQuery(sql).mapping(row -> this.mapper.commit(row)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> this.errorHandler.deadEnd("Can't find 'COMMIT'!", (Throwable)e));
    }

    public CommitQueryFilePool(Table.FilePool client, Table.FileMapper mapper, FileBuilder builder, ErrorHandler errorHandler) {
        this.client = client;
        this.mapper = mapper;
        this.builder = builder;
        this.errorHandler = errorHandler;
    }
}

