/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Objects.TreeValue", generator="Immutables")
@Immutable
public final class ImmutableTreeValue
implements Objects.TreeValue {
    private final String name;
    private final String blob;

    private ImmutableTreeValue(String name, String blob) {
        this.name = name;
        this.blob = blob;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBlob() {
        return this.blob;
    }

    public final ImmutableTreeValue withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeValue(newValue, this.blob);
    }

    public final ImmutableTreeValue withBlob(String value) {
        String newValue = Objects.requireNonNull(value, "blob");
        if (this.blob.equals(newValue)) {
            return this;
        }
        return new ImmutableTreeValue(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTreeValue && this.equalTo((ImmutableTreeValue)another);
    }

    private boolean equalTo(ImmutableTreeValue another) {
        return this.name.equals(another.name) && this.blob.equals(another.blob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.blob.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TreeValue").omitNullValues().add("name", (Object)this.name).add("blob", (Object)this.blob).toString();
    }

    public static ImmutableTreeValue copyOf(Objects.TreeValue instance) {
        if (instance instanceof ImmutableTreeValue) {
            return (ImmutableTreeValue)instance;
        }
        return ImmutableTreeValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Objects.TreeValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_BLOB = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String blob;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.TreeValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.blob(instance.getBlob());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blob(String blob) {
            this.blob = Objects.requireNonNull(blob, "blob");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTreeValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTreeValue(this.name, this.blob);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("blob");
            }
            return "Cannot build TreeValue, some of required attributes are not set " + attributes;
        }
    }
}

