/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Objects.Tree", generator="Immutables")
@Immutable
public final class ImmutableTree
implements Objects.Tree {
    private final String id;
    private final ImmutableMap<String, Objects.TreeValue> values;

    private ImmutableTree(String id, ImmutableMap<String, Objects.TreeValue> values) {
        this.id = id;
        this.values = values;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ImmutableMap<String, Objects.TreeValue> getValues() {
        return this.values;
    }

    public final ImmutableTree withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTree(newValue, this.values);
    }

    public final ImmutableTree withValues(Map<String, ? extends Objects.TreeValue> entries) {
        if (this.values == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTree(this.id, (ImmutableMap<String, Objects.TreeValue>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTree && this.equalTo((ImmutableTree)another);
    }

    private boolean equalTo(ImmutableTree another) {
        return this.id.equals(another.id) && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Tree").omitNullValues().add("id", (Object)this.id).add("values", this.values).toString();
    }

    public static ImmutableTree copyOf(Objects.Tree instance) {
        if (instance instanceof ImmutableTree) {
            return (ImmutableTree)instance;
        }
        return ImmutableTree.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Objects.Tree", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private ImmutableMap.Builder<String, Objects.TreeValue> values = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.Tree instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.IsObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Objects.IsObject instance;
            if (object instanceof Objects.Tree) {
                instance = (Objects.Tree)object;
                this.putAllValues(instance.getValues());
            }
            if (object instanceof Objects.IsObject) {
                instance = (Objects.IsObject)object;
                this.id(instance.getId());
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putValues(String key, Objects.TreeValue value) {
            this.values.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putValues(Map.Entry<String, ? extends Objects.TreeValue> entry) {
            this.values.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder values(Map<String, ? extends Objects.TreeValue> entries) {
            this.values = ImmutableMap.builder();
            return this.putAllValues(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllValues(Map<String, ? extends Objects.TreeValue> entries) {
            this.values.putAll(entries);
            return this;
        }

        public ImmutableTree build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTree(this.id, (ImmutableMap<String, Objects.TreeValue>)this.values.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Tree, some of required attributes are not set " + attributes;
        }
    }
}

