/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Repo", generator="Immutables")
@Immutable
public final class ImmutableRepo
implements Repo {
    private final String id;
    private final String rev;
    private final String prefix;
    private final String name;

    private ImmutableRepo(String id, String rev, String prefix, String name) {
        this.id = id;
        this.rev = rev;
        this.prefix = prefix;
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRev() {
        return this.rev;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final ImmutableRepo withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(newValue, this.rev, this.prefix, this.name);
    }

    public final ImmutableRepo withRev(String value) {
        String newValue = Objects.requireNonNull(value, "rev");
        if (this.rev.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(this.id, newValue, this.prefix, this.name);
    }

    public final ImmutableRepo withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(this.id, this.rev, newValue, this.name);
    }

    public final ImmutableRepo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRepo(this.id, this.rev, this.prefix, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepo && this.equalTo((ImmutableRepo)another);
    }

    private boolean equalTo(ImmutableRepo another) {
        return this.id.equals(another.id) && this.rev.equals(another.rev) && this.prefix.equals(another.prefix) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.rev.hashCode();
        h += (h << 5) + this.prefix.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Repo").omitNullValues().add("id", (Object)this.id).add("rev", (Object)this.rev).add("prefix", (Object)this.prefix).add("name", (Object)this.name).toString();
    }

    public static ImmutableRepo copyOf(Repo instance) {
        if (instance instanceof ImmutableRepo) {
            return (ImmutableRepo)instance;
        }
        return ImmutableRepo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Repo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_REV = 2L;
        private static final long INIT_BIT_PREFIX = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String rev;
        @Nullable
        private String prefix;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Repo instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.rev(instance.getRev());
            this.prefix(instance.getPrefix());
            this.name(instance.getName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rev(String rev) {
            this.rev = Objects.requireNonNull(rev, "rev");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRepo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepo(this.id, this.rev, this.prefix, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rev");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("prefix");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Repo, some of required attributes are not set " + attributes;
        }
    }
}

