/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Objects.Ref", generator="Immutables")
@Immutable
public final class ImmutableRef
implements Objects.Ref {
    private final String name;
    private final String commit;

    private ImmutableRef(String name, String commit) {
        this.name = name;
        this.commit = commit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    public final ImmutableRef withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRef(newValue, this.commit);
    }

    public final ImmutableRef withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableRef(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRef && this.equalTo((ImmutableRef)another);
    }

    private boolean equalTo(ImmutableRef another) {
        return this.name.equals(another.name) && this.commit.equals(another.commit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.commit.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Ref").omitNullValues().add("name", (Object)this.name).add("commit", (Object)this.commit).toString();
    }

    public static ImmutableRef copyOf(Objects.Ref instance) {
        if (instance instanceof ImmutableRef) {
            return (ImmutableRef)instance;
        }
        return ImmutableRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Objects.Ref", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String commit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.IsName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.Ref instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Objects.IsName instance;
            if (object instanceof Objects.IsName) {
                instance = (Objects.IsName)object;
                this.name(instance.getName());
            }
            if (object instanceof Objects.Ref) {
                instance = (Objects.Ref)object;
                this.commit(instance.getCommit());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRef build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRef(this.name, this.commit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            return "Cannot build Ref, some of required attributes are not set " + attributes;
        }
    }
}

