/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Message;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Message", generator="Immutables")
@Immutable
public final class ImmutableMessage
implements Message {
    private final String text;

    private ImmutableMessage(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public final ImmutableMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableMessage(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessage && this.equalTo((ImmutableMessage)another);
    }

    private boolean equalTo(ImmutableMessage another) {
        return this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Message").omitNullValues().add("text", (Object)this.text).toString();
    }

    public static ImmutableMessage copyOf(Message instance) {
        if (instance instanceof ImmutableMessage) {
            return (ImmutableMessage)instance;
        }
        return ImmutableMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Message", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private String text;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.text(instance.getText());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessage(this.text);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build Message, some of required attributes are not set " + attributes;
        }
    }
}

