/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Diff;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff.Divergence", generator="Immutables")
@Immutable
public final class ImmutableDivergence
implements Diff.Divergence {
    private final Diff.DivergenceType type;
    private final Diff.DivergenceRef head;
    private final Diff.DivergenceRef main;
    private final ImmutableList<Diff.DiffAction> actions;

    private ImmutableDivergence(Diff.DivergenceType type, Diff.DivergenceRef head, Diff.DivergenceRef main, ImmutableList<Diff.DiffAction> actions) {
        this.type = type;
        this.head = head;
        this.main = main;
        this.actions = actions;
    }

    @Override
    public Diff.DivergenceType getType() {
        return this.type;
    }

    @Override
    public Diff.DivergenceRef getHead() {
        return this.head;
    }

    @Override
    public Diff.DivergenceRef getMain() {
        return this.main;
    }

    public ImmutableList<Diff.DiffAction> getActions() {
        return this.actions;
    }

    public final ImmutableDivergence withType(Diff.DivergenceType value) {
        if (this.type == value) {
            return this;
        }
        Diff.DivergenceType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDivergence(newValue, this.head, this.main, this.actions);
    }

    public final ImmutableDivergence withHead(Diff.DivergenceRef value) {
        if (this.head == value) {
            return this;
        }
        Diff.DivergenceRef newValue = Objects.requireNonNull(value, "head");
        return new ImmutableDivergence(this.type, newValue, this.main, this.actions);
    }

    public final ImmutableDivergence withMain(Diff.DivergenceRef value) {
        if (this.main == value) {
            return this;
        }
        Diff.DivergenceRef newValue = Objects.requireNonNull(value, "main");
        return new ImmutableDivergence(this.type, this.head, newValue, this.actions);
    }

    public final ImmutableDivergence withActions(Diff.DiffAction ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDivergence(this.type, this.head, this.main, (ImmutableList<Diff.DiffAction>)newValue);
    }

    public final ImmutableDivergence withActions(Iterable<? extends Diff.DiffAction> elements) {
        if (this.actions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDivergence(this.type, this.head, this.main, (ImmutableList<Diff.DiffAction>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDivergence && this.equalTo((ImmutableDivergence)another);
    }

    private boolean equalTo(ImmutableDivergence another) {
        return this.type.equals((Object)another.type) && this.head.equals(another.head) && this.main.equals(another.main) && this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.head.hashCode();
        h += (h << 5) + this.main.hashCode();
        h += (h << 5) + this.actions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Divergence").omitNullValues().add("type", (Object)this.type).add("head", (Object)this.head).add("main", (Object)this.main).add("actions", this.actions).toString();
    }

    public static ImmutableDivergence copyOf(Diff.Divergence instance) {
        if (instance instanceof ImmutableDivergence) {
            return (ImmutableDivergence)instance;
        }
        return ImmutableDivergence.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff.Divergence", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_HEAD = 2L;
        private static final long INIT_BIT_MAIN = 4L;
        private long initBits = 7L;
        @Nullable
        private Diff.DivergenceType type;
        @Nullable
        private Diff.DivergenceRef head;
        @Nullable
        private Diff.DivergenceRef main;
        private ImmutableList.Builder<Diff.DiffAction> actions = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff.Divergence instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.head(instance.getHead());
            this.main(instance.getMain());
            this.addAllActions(instance.getActions());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Diff.DivergenceType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder head(Diff.DivergenceRef head) {
            this.head = Objects.requireNonNull(head, "head");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder main(Diff.DivergenceRef main) {
            this.main = Objects.requireNonNull(main, "main");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addActions(Diff.DiffAction element) {
            this.actions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addActions(Diff.DiffAction ... elements) {
            this.actions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actions(Iterable<? extends Diff.DiffAction> elements) {
            this.actions = ImmutableList.builder();
            return this.addAllActions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllActions(Iterable<? extends Diff.DiffAction> elements) {
            this.actions.addAll(elements);
            return this;
        }

        public ImmutableDivergence build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDivergence(this.type, this.head, this.main, (ImmutableList<Diff.DiffAction>)this.actions.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("head");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("main");
            }
            return "Cannot build Divergence, some of required attributes are not set " + attributes;
        }
    }
}

