/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Diff;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff.DiffBlob", generator="Immutables")
@Immutable
public final class ImmutableDiffBlob
implements Diff.DiffBlob {
    private final String id;
    private final String name;
    private final String content;

    private ImmutableDiffBlob(String id, String name, String content) {
        this.id = id;
        this.name = name;
        this.content = content;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public final ImmutableDiffBlob withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableDiffBlob(newValue, this.name, this.content);
    }

    public final ImmutableDiffBlob withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableDiffBlob(this.id, newValue, this.content);
    }

    public final ImmutableDiffBlob withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableDiffBlob(this.id, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffBlob && this.equalTo((ImmutableDiffBlob)another);
    }

    private boolean equalTo(ImmutableDiffBlob another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffBlob").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("content", (Object)this.content).toString();
    }

    public static ImmutableDiffBlob copyOf(Diff.DiffBlob instance) {
        if (instance instanceof ImmutableDiffBlob) {
            return (ImmutableDiffBlob)instance;
        }
        return ImmutableDiffBlob.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff.DiffBlob", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_CONTENT = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff.DiffBlob instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.content(instance.getContent());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDiffBlob build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffBlob(this.id, this.name, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build DiffBlob, some of required attributes are not set " + attributes;
        }
    }
}

